#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.11';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfoK5',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9405',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 85 => 0x69 },
	'about' => { 363 => 'about' },
	'abspeakaudiofilepath' => { 369 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 66 => 0x518 },
	'accessorytype' => { 248 => 0x53 },
	'actionadvised' => { 101 => 0x2a },
	'activearea' => { 93 => 0xc68d },
	'actived-lighting' => { 179 => 0x22, 210 => 0x24 },
	'actived-lightingmode' => { 210 => 0x25 },
	'addaspectratioinfo' => { 66 => 0x80e },
	'additionalmodelinformation' => { 356 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 66 => 0x80f, 67 => 0x11, 68 => 0x13, 71 => 0x14 },
	'address' => { 128 => 'Address' },
	'adjustmentmode' => { 304 => 0x15 },
	'adobe' => { 94 => 'Adobe' },
	'adultcontentwarning' => { 359 => 'AdultContentWarning', 362 => 'adultContentWarning' },
	'advancedraw' => { 212 => 0x76a43203 },
	'advancedscenetype' => { 248 => 0x3d },
	'advisory' => { 367 => 'Advisory' },
	'ae_iso' => { 253 => 0x2, 254 => 0x4, 255 => 0x12 },
	'aeaperture' => { 253 => 0x1, 254 => 0x3, 255 => 0x11 },
	'aebautocancel' => { 66 => 0x104 },
	'aebbracketvalue' => { 60 => 0x11 },
	'aebsequence' => { 66 => 0x105 },
	'aebsequenceautocancel' => { 64 => 0x9, 65 => 0x9, 67 => 0x8, 68 => 0x9, 71 => 0x9, 72 => 0x7 },
	'aebshotcount' => { 66 => 0x106 },
	'aebxv' => { 253 => 0x4, 254 => 0x6 },
	'aeerror' => { 254 => 0x8 },
	'aeexposuretime' => { 253 => 0x0, 254 => 0x2, 255 => 0x10 },
	'aelbutton' => { 148 => 0x45 },
	'aelexposureindicator' => { 148 => 0x51 },
	'aelock' => { 148 => 0x5b, 220 => '4.2', 226 => '4.2', 229 => 0x201, 279 => 0x48, 310 => 0x86 },
	'aelockbutton' => { 219 => '16.1', 220 => '4.1', 221 => '15.1', 222 => '16.1', 223 => '16.1', 224 => '30.1', 225 => '16.1', 226 => '4.1', 228 => '17.1' },
	'aelockbuttonplusdials' => { 219 => '16.2', 224 => '32.1' },
	'aelockformb-d80' => { 228 => '3.1' },
	'aemaxaperture' => { 253 => 0x9, 254 => 0x10, 255 => 0x1c },
	'aemaxaperture2' => { 253 => 0xa, 254 => 0x11, 255 => 0x1d },
	'aemeteringmode' => { 253 => 0xc },
	'aemeteringsegments' => { 151 => 0x628, 279 => 0x209 },
	'aemicroadjustment' => { 66 => 0x111 },
	'aeminaperture' => { 253 => 0xb, 254 => 0x12, 255 => 0x1e },
	'aeminexposuretime' => { 253 => 0x5, 254 => 0x13, 255 => 0x1f },
	'aeprogrammode' => { 253 => 0x6 },
	'aesetting' => { 27 => 0x21 },
	'aexv' => { 253 => 0x3, 254 => 0x5 },
	'af-cpriorityselection' => { 219 => '1.1', 222 => '0.1', 223 => '0.1', 224 => '1.1', 225 => '0.1' },
	'af-onformb-d10' => { 219 => '3.3', 224 => '3.2' },
	'af-onformb-d11' => { 225 => '2.2' },
	'af-spriorityselection' => { 219 => '1.2', 224 => '1.2', 225 => '0.2' },
	'afactivation' => { 219 => '2.1', 224 => '2.1' },
	'afadjustment' => { 279 => 0x72 },
	'afandmeteringbuttons' => { 66 => 0x701 },
	'afaperture' => { 175 => 0x5, 176 => 0x5 },
	'afareaheight' => { 156 => 0x1a },
	'afareaillumination' => { 148 => 0x4b, 226 => '15.3' },
	'afareamode' => { 144 => 0x33, 148 => 0xe, 155 => 0x0, 156 => 0x5, 248 => 0xf, 305 => 0xa, 308 => 0x11, 309 => 0x10, 310 => 0x24, 319 => 0xb043, 328 => 0x17 },
	'afareamodesetting' => { 220 => '11.1', 221 => '0.1', 226 => '16.1', 228 => '2.1', 319 => 0x201c },
	'afareas' => { 229 => 0x304 },
	'afareawidth' => { 156 => 0x18 },
	'afareaxposition' => { 156 => 0x14 },
	'afareayposition' => { 156 => 0x16 },
	'afassist' => { 64 => 0x5, 72 => 0x5, 148 => 0x48, 219 => '2.5', 220 => '0.2', 221 => '0.2', 222 => '1.1', 223 => '1.1', 224 => '2.4', 225 => '1.4', 226 => '0.2', 228 => '2.3' },
	'afassistbeam' => { 66 => 0x50e, 67 => 0x4, 68 => 0x5, 69 => 0x4, 70 => 0x4, 71 => 0x5 },
	'afassistlamp' => { 248 => 0x31 },
	'afbuttonpressed' => { 310 => 0x83 },
	'afdefocus' => { 256 => 0x6 },
	'afduringliveview' => { 66 => 0x511 },
	'affinea' => { 341 => 'AffineA' },
	'affineb' => { 341 => 'AffineB' },
	'affinec' => { 341 => 'AffineC' },
	'affined' => { 341 => 'AffineD' },
	'affinetune' => { 157 => 0x0, 229 => 0x306 },
	'affinetuneadj' => { 157 => 0x2, 187 => 0x2d1, 188 => 0x2dc, 229 => 0x307 },
	'affinetuneindex' => { 157 => 0x1 },
	'affinex' => { 341 => 'AffineX' },
	'affiney' => { 341 => 'AffineY' },
	'afilluminator' => { 308 => 0x29, 319 => 0xb044 },
	'afimageheight' => { 156 => 0x12 },
	'afimagewidth' => { 156 => 0x10 },
	'afintegrationtime' => { 256 => 0x7 },
	'afmicroadj' => { 305 => 0x17d },
	'afmicroadjmode' => { 1 => 0x1, 307 => 0x131 },
	'afmicroadjregisteredlenses' => { 307 => '305.1' },
	'afmicroadjustment' => { 66 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2, 307 => 0x130 },
	'afmode' => { 89 => 0x3009, 144 => 0x16, 304 => 0x5 },
	'afonaelockbuttonswitch' => { 66 => 0x702 },
	'afonbutton' => { 219 => '3.1' },
	'afpoint' => { 27 => 0x13, 88 => 0x18, 144 => 0x15, 155 => 0x1, 232 => 0x308, 304 => 0x1f, 305 => 0x7, 306 => 0x20 },
	'afpointactivationarea' => { 65 => 0x11, 71 => 0x11 },
	'afpointareaexpansion' => { 66 => 0x508 },
	'afpointatshutterrelease' => { 305 => 0x9 },
	'afpointautoselection' => { 66 => 0x50b },
	'afpointbrightness' => { 66 => 0x50d, 219 => '2.4' },
	'afpointdisplayduringfocus' => { 66 => 0x50c },
	'afpointillumination' => { 65 => 0xa, 219 => '2.3', 224 => '2.3', 225 => '1.3', 228 => '2.4' },
	'afpointinfocus' => { 305 => 0x8 },
	'afpointmode' => { 260 => 0x3 },
	'afpointposition' => { 89 => 0x2021, 248 => 0x4d },
	'afpointregistration' => { 64 => 0x7 },
	'afpoints' => { 147 => 0x10 },
	'afpointselected' => { 148 => 0xd, 229 => 0x305, 279 => 0xe, 306 => 0x1c, 308 => 0x12, 309 => 0x11, 319 => 0x201e },
	'afpointselected2' => { 260 => 0x4 },
	'afpointselection' => { 65 => 0xb, 219 => '1.3', 224 => '1.3' },
	'afpointselectionmethod' => { 66 => 0x50f, 67 => 0xc, 68 => 0xd, 71 => 0xd },
	'afpointsinfocus' => { 60 => 0xe, 155 => 0x2, 256 => 0xb, 279 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 16 => 0x38 },
	'afpointspotmetering' => { 65 => 0xd },
	'afpointsselected' => { 332 => 0x4 },
	'afpointsunknown1' => { 256 => 0x0 },
	'afpointsunknown2' => { 256 => 0x2 },
	'afpointsused' => { 156 => 0x8 },
	'afpredictor' => { 256 => 0x4 },
	'afresponse' => { 179 => 0xad },
	'afresult' => { 234 => 0x1038 },
	'afsearch' => { 229 => 0x303 },
	'afsensoractive' => { 144 => 0x1 },
	'afstatusactivesensor' => { 144 => 0x2 },
	'afstatusbottom' => { 144 => 0x8 },
	'afstatusbottom-left' => { 144 => 0x12 },
	'afstatusbottom-right' => { 144 => 0x6 },
	'afstatuscenterhorizontal' => { 144 => 0x2f },
	'afstatuscentervertical' => { 144 => 0xc },
	'afstatusleft' => { 144 => 0x2d },
	'afstatusmiddlehorizontal' => { 144 => 0xa },
	'afstatusright' => { 144 => 0x31 },
	'afstatustop' => { 144 => 0xe },
	'afstatustop-left' => { 144 => 0x10 },
	'afstatustop-right' => { 144 => 0x4 },
	'aftype' => { 305 => 0x2 },
	'afwithshutter' => { 308 => 0x2a },
	'aggregationtype' => { 360 => 'aggregationType' },
	'agreement' => { 362 => 'agreement' },
	'aiservocontinuousshooting' => { 65 => 0x15 },
	'aiservofirstimagepriority' => { 66 => 0x519 },
	'aiservoimagepriority' => { 66 => 0x503 },
	'aiservosecondimagepriority' => { 66 => 0x51a },
	'aiservotrackingmethod' => { 66 => 0x504 },
	'aiservotrackingsensitivity' => { 65 => 0x14, 66 => 0x502 },
	'album' => { 369 => 'album' },
	'alreadyapplied' => { 347 => 'AlreadyApplied' },
	'alternatetitle' => { 360 => 'alternateTitle' },
	'alttapename' => { 369 => 'altTapeName' },
	'alttimecode' => { 369 => 'altTimecode' },
	'alttimecodetimeformat' => { 369 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 369 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 369 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 2 => 0x1 },
	'ambienttemperature' => { 292 => 0x14, 328 => 0x4 },
	'ambienttemperaturefahrenheit' => { 292 => 0x13 },
	'analogbalance' => { 93 => 0xc627 },
	'angleadj' => { 85 => 0x8b },
	'angleinforoll' => { 343 => 'AngleInfoRoll' },
	'anti-blur' => { 319 => 0xb04b },
	'antialiasstrength' => { 93 => 0xc632 },
	'aperturerange' => { 66 => 0x10d },
	'apertureringuse' => { 260 => '1.4' },
	'aperturesetting' => { 148 => 0x7, 308 => 0x30, 309 => 0x29, 310 => 0x1 },
	'aperturevalue' => { 75 => 0x2, 93 => 0x9202, 234 => 0x1002, 351 => 'ApertureValue' },
	'applekeywords' => { 238 => 'AAPL:Keywords' },
	'applicationnotes' => { 93 => 0x2bc, 252 => 0x2bc },
	'applicationrecordversion' => { 101 => 0x0 },
	'applyshootingmeteringmode' => { 66 => 0x10e },
	'approved' => { 352 => 'Approved' },
	'approvedby' => { 352 => 'ApprovedBy' },
	'approximatefnumber' => { 244 => 0x313, 250 => 0x3406 },
	'approximatefocusdistance' => { 344 => 'ApproximateFocusDistance' },
	'armidentifier' => { 102 => 0x78 },
	'armversion' => { 102 => 0x7a },
	'artfilter' => { 229 => 0x529 },
	'artfiltereffect' => { 229 => 0x52f },
	'artist' => { 93 => 0x13b, 240 => 'Artist', 279 => 0x22e, 365 => 'Artist', 369 => 'artist' },
	'artmode' => { 89 => 0x301b },
	'artmodeparameters' => { 89 => 0x310b },
	'artworkcopyrightnotice' => { 356 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 356 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 356 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 356 => 'ArtworkOrObject' },
	'artworksource' => { 356 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 356 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 356 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 233 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 233 => 0x1112, 279 => 0x80, 308 => 0x55, 309 => 0x55, 310 => 0xa },
	'asshoticcprofile' => { 93 => 0xc68f },
	'asshotneutral' => { 93 => 0xc628 },
	'asshotpreprofilematrix' => { 93 => 0xc690 },
	'asshotprofilename' => { 93 => 0xc6f6 },
	'asshotwhitexy' => { 93 => 0xc629 },
	'assignbktbutton' => { 219 => '4.2' },
	'assignfuncbutton' => { 66 => 0x70b },
	'assistbuttonfunction' => { 64 => 0xd },
	'attributionname' => { 345 => 'attributionName' },
	'attributionurl' => { 345 => 'attributionURL' },
	'audio' => { 248 => 0x20 },
	'audiobitrate' => { 52 => 0x6c },
	'audiochannels' => { 52 => 0x70 },
	'audiochanneltype' => { 369 => 'audioChannelType' },
	'audiocompression' => { 122 => 'Compression' },
	'audiocompressor' => { 369 => 'audioCompressor' },
	'audioduration' => { 101 => 0x99 },
	'audiomoddate' => { 369 => 'audioModDate' },
	'audiooutcue' => { 101 => 0x9a },
	'audiosamplerate' => { 52 => 0x6e, 369 => 'audioSampleRate' },
	'audiosampletype' => { 369 => 'audioSampleType' },
	'audiosamplingrate' => { 101 => 0x97 },
	'audiosamplingresolution' => { 101 => 0x98 },
	'audiotype' => { 101 => 0x96 },
	'author' => { 124 => 'Author', 238 => 'Author', 240 => 'Author', 291 => 'Author', 342 => 'author', 357 => 'Author', 367 => 'Author' },
	'authorsposition' => { 358 => 'AuthorsPosition' },
	'autoaperture' => { 270 => '0.1' },
	'autobracket' => { 304 => 0x19 },
	'autobracketing' => { 98 => 0x1100, 279 => 0x18 },
	'autobracketingmode' => { 227 => '12.3' },
	'autobracketingset' => { 227 => '12.1' },
	'autobracketmodem' => { 219 => '21.2', 224 => '26.2' },
	'autobracketorder' => { 148 => 0x43, 219 => '21.3', 224 => '26.3', 225 => '12.2', 226 => '2.2', 227 => '12.2', 228 => '13.2' },
	'autobracketset' => { 219 => '21.1', 221 => '11.1', 222 => '12.1', 223 => '12.1', 224 => '26.1', 225 => '12.1', 226 => '2.1', 228 => '13.1' },
	'autobrightness' => { 347 => 'AutoBrightness' },
	'autocontrast' => { 347 => 'AutoContrast' },
	'autodistortioncontrol' => { 165 => 0x4 },
	'autodynamicrange' => { 98 => 0x140b },
	'autoexposure' => { 347 => 'AutoExposure' },
	'autoexposurebracketing' => { 60 => 0x10 },
	'autofocus' => { 232 => 0x209 },
	'autofp' => { 226 => '7.3', 228 => '31.4' },
	'autoiso' => { 60 => 0x1, 89 => 0x3008, 220 => '1.1', 226 => '1.1' },
	'autoisomax' => { 220 => '1.2', 226 => '1.2' },
	'autoisominshutterspeed' => { 220 => '1.3', 226 => '1.3' },
	'autolateralca' => { 347 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 13 => 0xbe, 14 => 0xbf, 17 => 0xbf, 48 => 0x2, 66 => 0x204, 85 => 0x6f },
	'autolightingoptimizeron' => { 85 => 0x6e },
	'autoportraitframed' => { 319 => 0x2016 },
	'autoredeye' => { 212 => 0xfe28a44f },
	'autorotate' => { 60 => 0x1b },
	'autoshadows' => { 347 => 'AutoShadows' },
	'auxiliarylens' => { 179 => 0x82 },
	'avaperturesetting' => { 260 => 0x13 },
	'averagelv' => { 151 => 0x38 },
	'avsettingwithoutlens' => { 66 => 0x707 },
	'azimuth' => { 132 => 'Azimuth' },
	'babyage' => { 248 => [0x8010,0x33] },
	'babyname' => { 248 => 0x66 },
	'backgroundalpha' => { 364 => 'bgalpha' },
	'baseexposurecompensation' => { 260 => 0x15 },
	'baseiso' => { 60 => 0x2, 79 => 0x101c, 250 => 0x312a },
	'baselineexposure' => { 93 => 0xc62a },
	'baselineexposureoffset' => { 93 => 0xc7a5 },
	'baselinenoise' => { 93 => 0xc62b },
	'baselinesharpness' => { 93 => 0xc62c },
	'baseurl' => { 367 => 'BaseURL' },
	'batterylevel' => { 308 => 0x51, 312 => 0xc, 313 => 0x4, 314 => 0x4, 331 => 0x7 },
	'batteryorder' => { 219 => '12.5', 224 => '13.2', 225 => '2.1' },
	'batterystate' => { 148 => 0x60, 314 => 0x14 },
	'batterytemperature' => { 312 => 0x1, 314 => 0x2 },
	'batteryunknown' => { 312 => 0x2, 314 => 0x0 },
	'batteryvoltage' => { 292 => 0x2a, 312 => 0x8 },
	'batteryvoltage1' => { 314 => 0x6 },
	'batteryvoltage2' => { 314 => 0x8 },
	'bayergreensplit' => { 93 => 0xc62d },
	'bayerpattern' => { 106 => 0xf902, 152 => 0x17 },
	'beatspliceparams' => { 369 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 369 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 369 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 369 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 369 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 369 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 219 => '13.1', 220 => '0.1', 221 => '2.1', 222 => '3.1', 223 => '3.1', 224 => '10.1', 226 => '0.1', 228 => '4.1' },
	'beeppitch' => { 225 => '3.1' },
	'beepvolume' => { 225 => '4.5' },
	'bestqualityscale' => { 93 => 0xc65c },
	'bestshotmode' => { 89 => 0x3007 },
	'bitdepth' => { 129 => 'BitDepth', 152 => 0x11, 184 => 0x41 },
	'bitspercomponent' => { 103 => 0x87 },
	'bitspersample' => { 93 => 0x102, 365 => 'BitsPerSample' },
	'blacklevel' => { 93 => 0xc61a, 234 => 0x1012 },
	'blacklevel2' => { 233 => 0x600, 237 => 0x600 },
	'blackleveldeltah' => { 93 => 0xc61b },
	'blackleveldeltav' => { 93 => 0xc61c },
	'blacklevelrepeatdim' => { 93 => 0xc619 },
	'blackpoint' => { 279 => 0x200 },
	'blacks2012' => { 347 => 'Blacks2012' },
	'bleachbypasstoning' => { 279 => 0x7f },
	'bluebalance' => { 163 => 0x271, 234 => 0x1018, 252 => 0x12, 279 => 0x1b },
	'bluecurvelimits' => { 84 => 0x1fe },
	'bluecurvepoints' => { 84 => 0x1d4 },
	'bluehue' => { 347 => 'BlueHue' },
	'bluesaturation' => { 347 => 'BlueSaturation' },
	'blurcontrol' => { 279 => 0x82 },
	'blurwarning' => { 98 => 0x1300 },
	'bodybatteryadload' => { 258 => 0x3 },
	'bodybatteryadnoload' => { 258 => 0x2 },
	'bodybatterystate' => { 258 => '1.1' },
	'bodybatteryvoltage1' => { 258 => 0x2 },
	'bodybatteryvoltage2' => { 258 => 0x4 },
	'bodybatteryvoltage3' => { 258 => 0x6 },
	'bodybatteryvoltage4' => { 258 => 0x8 },
	'bodyfirmware' => { 297 => 0x0 },
	'bodyfirmwareversion' => { 230 => 0x104, 231 => 0x100, 234 => 0x104 },
	'bodyserialnumber' => { 297 => 0x10 },
	'bracketmode' => { 44 => 0x3 },
	'bracketsequence' => { 89 => 0x301d },
	'bracketshotnumber' => { 44 => 0x5, 260 => 0x9, 318 => 0x2b },
	'bracketshotnumber2' => { 318 => 0x2d },
	'bracketstep' => { 145 => 0xe },
	'bracketvalue' => { 44 => 0x4 },
	'brightness' => { 93 => 0xfe53, 123 => 'Brightness', 145 => 0x2c, 181 => 0x34, 292 => 0x25, 308 => 0x22, 319 => 0x2007, 347 => 'Brightness' },
	'brightnessadj' => { 84 => 0x114, 205 => 0x0, 215 => 0x2d, 333 => 0x8018 },
	'brightnessvalue' => { 93 => 0x9203, 151 => [0x691,0x49c3], 234 => 0x1003, 351 => 'BrightnessValue' },
	'bulbduration' => { 60 => 0x18 },
	'burstmode' => { 109 => 0xa, 248 => 0x2a },
	'burstmode2' => { 109 => 0x18 },
	'burstshot' => { 304 => 0x34 },
	'buttonfunctioncontroloff' => { 66 => 0x70a },
	'bwfilter' => { 145 => 0x2a, 153 => 0x39 },
	'bwmode' => { 234 => 0x203 },
	'by-line' => { 101 => 0x50 },
	'by-linetitle' => { 101 => 0x55 },
	'bytecount' => { 360 => 'byteCount' },
	'calibration' => { 304 => [0x24,0x30] },
	'calibrationilluminant1' => { 93 => 0xc65a },
	'calibrationilluminant2' => { 93 => 0xc65b },
	'cameraangle' => { 369 => 'cameraAngle' },
	'cameracalibration1' => { 93 => 0xc623 },
	'cameracalibration2' => { 93 => 0xc624 },
	'cameracalibrationsig' => { 93 => 0xc6f3 },
	'cameracolorcalibration01' => { 29 => 0x0, 35 => 0xba },
	'cameracolorcalibration02' => { 29 => 0x4, 35 => 0xbf },
	'cameracolorcalibration03' => { 29 => 0x8, 35 => 0xc4 },
	'cameracolorcalibration04' => { 29 => 0xc, 35 => 0xc9 },
	'cameracolorcalibration05' => { 29 => 0x10, 35 => 0xce },
	'cameracolorcalibration06' => { 29 => 0x14, 35 => 0xd3 },
	'cameracolorcalibration07' => { 29 => 0x18, 35 => 0xd8 },
	'cameracolorcalibration08' => { 29 => 0x1c, 35 => 0xdd },
	'cameracolorcalibration09' => { 29 => 0x20, 35 => 0xe2 },
	'cameracolorcalibration10' => { 29 => 0x24, 35 => 0xe7 },
	'cameracolorcalibration11' => { 29 => 0x28, 35 => 0xec },
	'cameracolorcalibration12' => { 29 => 0x2c, 35 => 0xf1 },
	'cameracolorcalibration13' => { 29 => 0x30, 35 => 0xf6 },
	'cameracolorcalibration14' => { 29 => 0x34, 35 => 0xfb },
	'cameracolorcalibration15' => { 29 => 0x38, 35 => 0x100 },
	'cameraid' => { 234 => 0x209, 303 => 0x209 },
	'cameraiso' => { 27 => 0x10 },
	'cameralabel' => { 93 => 0xc7a1, 369 => 'cameraLabel' },
	'cameramodel' => { 369 => 'cameraModel' },
	'cameramove' => { 369 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 6 => 0x7d, 8 => 0x30, 10 => 0x35, 11 => 0x30, 12 => 0x30, 13 => 0x31, 14 => 0x31, 15 => 0x35, 16 => 0x27, 17 => 0x31, 18 => 0x7d, 19 => 0x38, 20 => 0x36, 21 => 0x7d, 22 => 0x83, 23 => 0x35, 281 => 0x1, 314 => 0x18, 326 => 0x28, 327 => 0x24 },
	'cameraowner' => { 110 => 0xc353 },
	'cameraparameters' => { 234 => 0x2050 },
	'cameraprofile' => { 347 => 'CameraProfile' },
	'cameraprofiledigest' => { 347 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 93 => 0xc62f, 143 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 229 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 6 => 0x1b, 8 => 0x18, 10 => 0x19, 11 => 0x18, 12 => 0x18, 13 => 0x19, 14 => 0x19, 15 => 0x19, 16 => 0x17, 17 => 0x19, 18 => 0x1b, 19 => 0x19, 20 => 0x19, 21 => 0x1b, 22 => 0x1b, 23 => 0x19, 24 => [0x87,0x91], 25 => [0x99,0x9f,0xa4,0xa8,0x105], 26 => [0x64,0x1d2,0x1f7,0x1fa,0x208,0x20c,0x47,0x53,0x5b,0x5c], 60 => 0xc, 244 => 0x320, 250 => 0x3402, 279 => 0x47, 301 => 0x43, 329 => 0x5 },
	'cameratemperature2' => { 282 => 0xc },
	'cameratemperature3' => { 282 => 0xe },
	'cameratemperature4' => { 282 => 0x14 },
	'cameratemperature5' => { 282 => 0x16 },
	'cameratemperaturerangemax' => { 95 => 0x5 },
	'cameratemperaturerangemin' => { 95 => 0x6 },
	'cameratype' => { 60 => 0x1a, 234 => 0x207 },
	'cameratype2' => { 230 => 0x100 },
	'canonexposuremode' => { 27 => 0x14 },
	'canonfiledescription' => { 79 => 0x805 },
	'canonfilelength' => { 49 => 0xe },
	'canonfirmwareversion' => { 49 => 0x7, 79 => 0x80b },
	'canonflashinfo' => { 79 => 0x1028 },
	'canonflashmode' => { 27 => 0x4 },
	'canonimagesize' => { 7 => 0x39, 27 => 0xa },
	'canonimagetype' => { 49 => 0x6, 79 => 0x815 },
	'canonmodelid' => { 49 => 0x10, 79 => 0x1834 },
	'canonvrd' => { 94 => 'CanonVRD' },
	'caption' => { 342 => 'caption' },
	'caption-abstract' => { 101 => 0x78 },
	'captionsauthornames' => { 350 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 350 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 358 => 'CaptionWriter' },
	'captureframerate' => { 89 => 0x4001 },
	'capturesoftware' => { 337 => 'CaptureSoftware' },
	'cardshutterlock' => { 148 => 0x49 },
	'casioimagesize' => { 89 => 0x9 },
	'catalogsets' => { 101 => 0xff, 336 => 'CatalogSets', 340 => 'CatalogSets' },
	'categories' => { 49 => 0x23, 342 => 'categories' },
	'category' => { 101 => 0xf, 358 => 'Category' },
	'ccdboardversion' => { 244 => 0x331 },
	'ccdscanmode' => { 234 => 0x1039 },
	'ccdsensitivity' => { 202 => 0x6 },
	'ccdversion' => { 244 => 0x330 },
	'cellglobalid' => { 346 => 'cgi' },
	'celllength' => { 93 => 0x109 },
	'cellr' => { 346 => 'r' },
	'celltowerid' => { 346 => 'cellid' },
	'cellwidth' => { 93 => 0x108 },
	'centerafarea' => { 226 => '15.1' },
	'centerfocuspoint' => { 228 => '2.2' },
	'centerweightedareasize' => { 219 => '7.1', 224 => '5.1', 225 => '7.1', 226 => '6.3', 228 => '8.1' },
	'certificate' => { 373 => 'Certificate' },
	'cfapattern' => { 93 => 0xa302, 351 => 'CFAPattern' },
	'cfapattern2' => { 93 => 0x828e },
	'cfapatterncolumns' => { 351 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 351 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 351 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 93 => 0x828d },
	'channel' => { 360 => 'channel' },
	'channels' => { 122 => 'Channels' },
	'checkmark' => { 84 => 0x26a },
	'checkmark2' => { 85 => 0x8e },
	'childfontfiles' => { 374 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 219 => '10.3' },
	'chromablurradius' => { 93 => 0xc631 },
	'chromaticaberration' => { 85 => 0x66 },
	'chromaticaberrationb' => { 347 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 85 => 0x6b },
	'chromaticaberrationcorr' => { 62 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 269 => 0x1 },
	'chromaticaberrationon' => { 85 => 0x62 },
	'chromaticaberrationr' => { 347 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 85 => 0x6a },
	'chromaticaberrationsetting' => { 63 => 0x6 },
	'chrominancenoisereduction' => { 85 => 0x5e, 304 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 85 => 0x60 },
	'city' => { 101 => 0x5a, 128 => 'City', 248 => 0x6d, 358 => 'City' },
	'clarity' => { 347 => 'Clarity' },
	'clarity2012' => { 347 => 'Clarity2012' },
	'classifystate' => { 101 => 0xe1 },
	'client' => { 369 => 'client' },
	'clientname' => { 352 => 'ClientName' },
	'clmodeshootingspeed' => { 219 => '10.2', 224 => '11.2', 225 => '10.2', 228 => '11.1' },
	'cmcontrast' => { 237 => 0x2022 },
	'cmexposurecompensation' => { 237 => 0x2000 },
	'cmhue' => { 237 => 0x2021 },
	'cmsaturation' => { 237 => 0x2020 },
	'cmsharpness' => { 237 => 0x2023 },
	'cmwhitebalance' => { 237 => 0x2001 },
	'cmwhitebalancecomp' => { 237 => 0x2002 },
	'cmwhitebalancegraypoint' => { 237 => 0x2010 },
	'codec' => { 136 => 'Codec' },
	'codedcharacterset' => { 102 => 0x5a },
	'collectionname' => { 137 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 137 => 'Collections' },
	'collectionuri' => { 137 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 212 => 0xc89224b },
	'coloradjustment' => { 304 => 0x14 },
	'coloradjustmentmode' => { 303 => 0x210 },
	'coloranta' => { 374 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 374 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 374 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 374 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 374 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 374 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 374 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 374 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 374 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 374 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 374 => 'Colorants' },
	'colorantswatchname' => { 374 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 374 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 374 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 374 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 123 => 'ColorBalance' },
	'colorbalanceadj' => { 212 => 0x76a43202 },
	'colorbalanceblue' => { 145 => 0x1e },
	'colorbalancegreen' => { 145 => 0x1d },
	'colorbalancered' => { 145 => 0x1c },
	'colorbalanceversion' => { 164 => 0x0 },
	'colorblur' => { 85 => 0x65 },
	'colorbooster' => { 212 => 0x5f0e7d23 },
	'colorboostlevel' => { 206 => 0x1 },
	'colorboosttype' => { 206 => 0x0 },
	'colorclass' => { 286 => 0xde, 287 => 'ColorClass' },
	'colorcompensationfilter' => { 148 => [0x3a,0x5f], 150 => 0x111, 319 => 0xb022 },
	'colorcompensationfilterset' => { 308 => 0xd, 309 => 0xc, 310 => 0x18, 322 => 0xf },
	'colorcontrol' => { 234 => 0x102b },
	'colorcorrection' => { 333 => 0x8015 },
	'colordataversion' => { 33 => 0x0, 34 => 0x0, 36 => 0x0, 37 => 0x0 },
	'coloreffect' => { 248 => 0x28 },
	'colorfilter' => { 88 => 0x17, 89 => 0x3017, 145 => 0x29, 153 => [0x38,0x4d,0x4f], 284 => 0x17 },
	'colorgain' => { 184 => 0x51 },
	'colorhue' => { 179 => 0x8d },
	'colorimetricreference' => { 93 => 0xc6bf },
	'colorlabel' => { 350 => 'ColorLabel' },
	'colormatrix' => { 233 => 0x200, 234 => 0x1011, 301 => 0xa030 },
	'colormatrix1' => { 93 => 0xc621 },
	'colormatrix2' => { 93 => 0xc622, 237 => 0x200 },
	'colormatrixa' => { 279 => 0x203 },
	'colormatrixadobergb' => { 301 => 0xa032 },
	'colormatrixb' => { 279 => 0x204 },
	'colormatrixnumber' => { 234 => 0x1019 },
	'colormatrixsrgb' => { 301 => 0xa031 },
	'colormode' => { 89 => 0x3015, 98 => 0x1210, 109 => 0x66, 145 => 0x28, 148 => 0x16, 150 => 0x101, 151 => 0x36, 153 => 0x7, 179 => 0x3, 202 => 0x4, 248 => 0x32, 304 => 0x2c, 319 => 0xb029, 358 => 'ColorMode' },
	'colormoirereduction' => { 213 => 0x15 },
	'colormoirereductionmode' => { 213 => 0x5 },
	'colornoisereduction' => { 333 => 0x8029, 347 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 347 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 213 => 0x18 },
	'colornoisereductionsharpness' => { 213 => 0x1c },
	'colorplanes' => { 97 => 0x2 },
	'colorprofile' => { 145 => 0x33 },
	'colorrepresentation' => { 103 => 0x3c },
	'colorsequence' => { 103 => 0x41 },
	'colorspace' => { 38 => 0x3, 49 => 0xb4, 79 => 0x10b4, 93 => 0xa001, 129 => 'ColorSpace', 146 => 0x2f, 147 => 0x25, 148 => 0x17, 179 => 0x1e, 229 => 0x507, 279 => 0x37, 301 => 0xa011, 304 => 0xb, 308 => 0x1b, 309 => 0x83, 310 => 0xe, 322 => 0x6, 351 => 'ColorSpace' },
	'colortempasshot' => { 30 => 0x4, 31 => 0x1d, 32 => 0x26, 33 => 0x43, 36 => 0x43, 37 => 0x43 },
	'colortempauto' => { 30 => 0x9, 31 => 0x22, 32 => 0x1c, 33 => 0x48, 36 => 0x48, 37 => 0x48 },
	'colortempcloudy' => { 30 => 0x22, 31 => 0x31, 32 => 0x35, 33 => 0x5c, 36 => 0x75, 37 => 0x8e, 279 => 0x55 },
	'colortempcustom' => { 33 => 0x84 },
	'colortempcustom1' => { 31 => 0x45 },
	'colortempcustom2' => { 31 => 0x4a },
	'colortempdaylight' => { 30 => 0x18, 31 => 0x27, 32 => 0x2b, 33 => 0x52, 36 => 0x6b, 37 => 0x84, 279 => 0x53 },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0xc0, 7 => 0x37, 8 => 0x62, 9 => 0x37, 10 => 0x7c, 11 => 0x73, 12 => 0x73, 13 => 0x77, 14 => 0x73, 15 => 0x7c, 16 => 0x58, 17 => 0x73, 18 => 0xc0, 19 => 0x7f, 20 => 0x7d, 21 => 0xc0, 22 => 0xc6, 23 => 0x7b, 49 => 0xae, 58 => 0x9, 79 => 0x10ae, 98 => 0x1005, 107 => 0x846, 123 => 'ColorTemperature', 146 => [0x6e,0x49], 147 => 0x3f, 148 => [0x39,0x5e], 150 => 0x10b, 153 => [0x3c,0x4c,0x4e], 244 => 0x321, 279 => 0x50, 319 => 0xb021, 347 => 'Temperature' },
	'colortemperatureadj' => { 333 => 0x8013 },
	'colortemperaturebg' => { 234 => 0x1013 },
	'colortemperaturerg' => { 234 => 0x1014 },
	'colortemperaturesetting' => { 148 => 0x25, 308 => 0xc, 309 => 0xb, 310 => 0x17, 322 => 0xe },
	'colortempflash' => { 30 => 0x36, 31 => 0x40, 32 => 0x49, 33 => 0x70, 36 => 0x89, 37 => 0xa2, 279 => 0x5a },
	'colortempflashdata' => { 33 => 0x24a },
	'colortempfluorescent' => { 30 => 0x2c, 31 => 0x3b, 32 => 0x3f, 33 => 0x66, 36 => 0x7f, 37 => 0x98 },
	'colortempfluorescentd' => { 279 => 0x57 },
	'colortempfluorescentn' => { 279 => 0x58 },
	'colortempfluorescentw' => { 279 => 0x59 },
	'colortempkelvin' => { 30 => 0x31, 32 => 0x44, 33 => 0x6b, 36 => 0x84, 37 => 0x9d, 248 => 0x44 },
	'colortempmeasured' => { 30 => 0xe, 33 => 0x4d, 36 => 0x4d, 37 => 0x4d },
	'colortemppc1' => { 32 => 0x94, 33 => 0x75 },
	'colortemppc2' => { 32 => 0x99, 33 => 0x7a },
	'colortemppc3' => { 32 => 0x9e, 33 => 0x7f },
	'colortempshade' => { 30 => 0x1d, 31 => 0x2c, 32 => 0x30, 33 => 0x57, 36 => 0x70, 37 => 0x89, 279 => 0x54 },
	'colortemptungsten' => { 30 => 0x27, 31 => 0x36, 32 => 0x3a, 33 => 0x61, 36 => 0x7a, 37 => 0x93, 279 => 0x56 },
	'colortempunknown' => { 30 => 0x13, 32 => 0x21, 36 => 0x52, 37 => 0x52 },
	'colortempunknown10' => { 30 => 0x63, 32 => 0x76, 36 => 0xa2, 37 => 0x7f },
	'colortempunknown11' => { 30 => 0x68, 32 => 0x7b, 36 => 0xa7, 37 => 0xa7 },
	'colortempunknown12' => { 30 => 0x6d, 32 => 0x80, 36 => 0xac, 37 => 0xac },
	'colortempunknown13' => { 30 => 0x72, 32 => 0x85, 36 => 0xb1, 37 => 0xb1 },
	'colortempunknown14' => { 32 => 0x8a, 36 => 0xb6, 37 => 0xb6 },
	'colortempunknown15' => { 32 => 0x8f, 36 => 0xbb, 37 => 0xbb },
	'colortempunknown16' => { 32 => 0xa3, 37 => 0xc0 },
	'colortempunknown17' => { 37 => 0xc5 },
	'colortempunknown18' => { 37 => 0xca },
	'colortempunknown19' => { 37 => 0xcf },
	'colortempunknown2' => { 30 => 0x3b, 32 => 0x4e, 36 => 0x57, 37 => 0x57 },
	'colortempunknown20' => { 37 => 0xd4 },
	'colortempunknown3' => { 30 => 0x40, 32 => 0x53, 36 => 0x5c, 37 => 0x5c },
	'colortempunknown4' => { 30 => 0x45, 32 => 0x58, 36 => 0x61, 37 => 0x61 },
	'colortempunknown5' => { 30 => 0x4a, 32 => 0x5d, 36 => 0x66, 37 => 0x66 },
	'colortempunknown6' => { 30 => 0x4f, 32 => 0x62, 36 => 0x8e, 37 => 0x6b },
	'colortempunknown7' => { 30 => 0x54, 32 => 0x67, 36 => 0x93, 37 => 0x70 },
	'colortempunknown8' => { 30 => 0x59, 32 => 0x6c, 36 => 0x98, 37 => 0x75 },
	'colortempunknown9' => { 30 => 0x5e, 32 => 0x71, 36 => 0x9d, 37 => 0x7a },
	'colortone' => { 7 => 0x6f, 9 => 0x77, 27 => 0x2a, 38 => 0x2 },
	'colortoneadj' => { 84 => 0x11e },
	'colortonefaithful' => { 16 => 0x107, 54 => 0x6c, 55 => 0x6c },
	'colortonelandscape' => { 16 => 0x105, 54 => 0x3c, 55 => 0x3c },
	'colortonemonochrome' => { 54 => 0x84, 55 => 0x84 },
	'colortoneneutral' => { 16 => 0x106, 54 => 0x54, 55 => 0x54 },
	'colortoneportrait' => { 16 => 0x104, 54 => 0x24, 55 => 0x24 },
	'colortonestandard' => { 16 => 0x103, 54 => 0xc, 55 => 0xc },
	'colortoneunknown' => { 55 => 0x9c },
	'colortoneuserdef1' => { 16 => 0x109, 54 => 0x9c, 55 => 0xb4 },
	'colortoneuserdef2' => { 16 => 0x10a, 54 => 0xb4, 55 => 0xcc },
	'colortoneuserdef3' => { 16 => 0x10b, 54 => 0xcc, 55 => 0xe4 },
	'commanddials' => { 226 => '5.1' },
	'commanddialsaperturesetting' => { 219 => '17.3', 224 => '33.3', 225 => '17.3' },
	'commanddialschangemainsub' => { 219 => '17.2', 224 => '33.2', 225 => '17.2' },
	'commanddialsmenuandplayback' => { 219 => '17.4', 224 => '33.4', 225 => '17.4' },
	'commanddialsreverserotation' => { 219 => '17.1', 221 => '16.2', 222 => '17.2', 224 => '33.1', 225 => '17.1', 228 => '18.1' },
	'commanderchannel' => { 226 => '10.2', 227 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 226 => '13.1', 227 => '31.1' },
	'commandergroupa_ttlcomp' => { 228 => '32.1' },
	'commandergroupamanualoutput' => { 226 => '13.2', 227 => '28.2' },
	'commandergroupamode' => { 226 => '11.2', 227 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 226 => '14.1', 227 => '32.1' },
	'commandergroupb_ttlcomp' => { 228 => '33.1' },
	'commandergroupbmanualoutput' => { 226 => '14.2', 227 => '29.2' },
	'commandergroupbmode' => { 226 => '11.3', 227 => '29.1' },
	'commanderinternalflash' => { 226 => '11.1', 227 => '27.1' },
	'commanderinternalmanualoutput' => { 226 => '12.2', 227 => '27.2' },
	'commanderinternalttlchannel' => { 224 => '18.2' },
	'commanderinternalttlcomp' => { 226 => '12.1', 227 => '30.2', 228 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 224 => '20.1', 225 => '26.1' },
	'commanderinternalttlcompgroupa' => { 224 => '21.1', 225 => '27.1' },
	'commanderinternalttlcompgroupb' => { 224 => '22.1', 225 => '28.1' },
	'comment' => { 0 => 0x2, 94 => 'Comment', 124 => 'Comment', 240 => 'Comment' },
	'complianceprofile' => { 360 => 'complianceProfile' },
	'componentsconfiguration' => { 93 => 0x9101, 129 => 'Components', 351 => 'ComponentsConfiguration' },
	'componentversion' => { 79 => 0x80c },
	'composer' => { 369 => 'composer' },
	'compositionadjust' => { 278 => '0.1' },
	'compositionadjustrotation' => { 278 => 0x7 },
	'compositionadjustx' => { 278 => 0x5 },
	'compositionadjusty' => { 278 => 0x6 },
	'compressedbitsperpixel' => { 93 => 0x9102, 351 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 150 => 0x40, 234 => 0x40 },
	'compression' => { 93 => 0x103, 365 => 'Compression' },
	'compressionfactor' => { 229 => 0x50d },
	'compressionratio' => { 129 => 'Compression', 234 => 0x1034 },
	'confidencelevel' => { 343 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 84 => 0x266, 286 => 0xd6 },
	'constrainedcropwidth' => { 84 => 0x262, 286 => 0xd5 },
	'contact' => { 101 => 0x76 },
	'contentlocationcode' => { 101 => 0x1a },
	'contentlocationname' => { 101 => 0x1b },
	'continuousbracketing' => { 148 => 0x20 },
	'continuousdrive' => { 27 => 0x5 },
	'continuousshootingspeed' => { 66 => 0x610 },
	'continuousshotlimit' => { 66 => 0x611 },
	'contrast' => { 7 => 0x73, 9 => 0x75, 27 => 0xd, 88 => 0xc, 89 => [0x3012,0x20], 93 => [0xa408,0xfe54], 98 => [0x1004,0x1006], 123 => 'Contrast', 145 => 0x20, 146 => 0x31, 147 => 0x27, 148 => 0x19, 153 => 0x2, 181 => 0x33, 234 => 0x1029, 248 => 0x39, 250 => 0x300a, 279 => 0x20, 284 => 0xc, 292 => 0x24, 304 => 0xd, 308 => 0x1d, 309 => 0x1a, 319 => 0x2004, 347 => 'Contrast', 351 => 'Contrast' },
	'contrast2012' => { 347 => 'Contrast2012' },
	'contrastadj' => { 84 => 0x115, 215 => 0x2c, 333 => 0x8017 },
	'contrastcurve' => { 179 => 0x8c },
	'contrastdetectaf' => { 156 => 0x4 },
	'contrastdetectafarea' => { 279 => 0x231 },
	'contrastdetectafinfocus' => { 156 => 0x1c },
	'contrastfaithful' => { 16 => 0xec, 54 => 0x60, 55 => 0x60 },
	'contrasthighlight' => { 279 => 0x6d },
	'contrasthighlightshadowadj' => { 279 => 0x6f },
	'contrastlandscape' => { 16 => 0xea, 54 => 0x30, 55 => 0x30 },
	'contrastmode' => { 248 => 0x2c },
	'contrastmonochrome' => { 16 => 0xed, 54 => 0x78, 55 => 0x78 },
	'contrastneutral' => { 16 => 0xeb, 54 => 0x48, 55 => 0x48 },
	'contrastportrait' => { 16 => 0xe9, 54 => 0x18, 55 => 0x18 },
	'contrastsetting' => { 229 => 0x505, 237 => 0x1012, 310 => 0x10, 322 => 0x8 },
	'contrastshadow' => { 279 => 0x6e },
	'contraststandard' => { 16 => 0xe8, 54 => 0x0, 55 => 0x0 },
	'contrastunknown' => { 55 => 0x90 },
	'contrastuserdef1' => { 16 => 0xee, 54 => 0x90, 55 => 0xa8 },
	'contrastuserdef2' => { 16 => 0xef, 54 => 0xa8, 55 => 0xc0 },
	'contrastuserdef3' => { 16 => 0xf0, 54 => 0xc0, 55 => 0xd8 },
	'contributedmedia' => { 369 => 'contributedMedia' },
	'contributedmediaduration' => { 369 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 369 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 369 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 369 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 369 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 369 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 369 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 369 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 369 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 369 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 348 => 'contributor' },
	'contributors' => { 124 => 'Contributors' },
	'controldialset' => { 148 => 0x46 },
	'controlledvocabularyterm' => { 356 => 'CVterm' },
	'controllerboardversion' => { 244 => 0x332 },
	'controlmode' => { 60 => 0x12 },
	'conversionlens' => { 230 => 0x403, 248 => 0x35 },
	'converter' => { 93 => 0xfe4d, 202 => 0xb, 347 => 'Converter' },
	'converttograyscale' => { 347 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 93 => 0x8298, 124 => 'Copyright', 240 => 'Copyright', 279 => 0x22f, 291 => 'Copyright', 357 => 'Copyright', 360 => 'copyright', 362 => 'copyright', 365 => 'Copyright', 369 => 'copyright' },
	'copyrightflag' => { 289 => 0x40a },
	'copyrightnotice' => { 101 => 0x74 },
	'copyrightowner' => { 359 => 'CopyrightOwner' },
	'copyrightownerid' => { 359 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 359 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 359 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 359 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 359 => 'CopyrightStatus' },
	'coringfilter' => { 233 => 0x310, 234 => 0x102d, 237 => 0x310 },
	'coringvalues' => { 233 => 0x311, 237 => 0x311 },
	'corporateentity' => { 360 => 'corporateEntity' },
	'country' => { 128 => 'Country', 248 => 0x69, 358 => 'Country' },
	'country-primarylocationcode' => { 101 => 0x64 },
	'country-primarylocationname' => { 101 => 0x65 },
	'countrycode' => { 178 => 0x5, 287 => 'CountryCode', 355 => 'CountryCode' },
	'coverage' => { 348 => 'coverage' },
	'coverdate' => { 360 => 'coverDate' },
	'coverdisplaydate' => { 360 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 279 => 0x28 },
	'crc32' => { 349 => 'crc32' },
	'createdate' => { 93 => 0x9004, 124 => 'CreateDate', 238 => 'CreationDate', 240 => 'create-date', 291 => 'CreationDate', 367 => 'CreateDate' },
	'creationdate' => { 357 => 'CreationDate', 360 => 'creationDate' },
	'creationtime' => { 240 => 'Creation Time' },
	'creativestyle' => { 308 => 0x1a, 309 => 0x18, 318 => 0x41, 319 => 0xb020 },
	'creativestylesetting' => { 310 => 0xf, 322 => 0x7 },
	'creativestylewaschanged' => { 333 => 0x8001 },
	'creator' => { 238 => 'Creator', 291 => 'Creator', 348 => 'creator', 357 => 'Creator' },
	'creatoraddress' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 355 => 'CreatorContactInfo' },
	'creatorcountry' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 367 => 'CreatorTool' },
	'creatorworkemail' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 355 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 101 => 0x6e, 358 => 'Credit' },
	'creditline' => { 362 => 'creditLine' },
	'creditlinereq' => { 372 => 'CreditLineReq' },
	'creditlinerequired' => { 359 => 'CreditLineRequired' },
	'cropactive' => { 84 => 0x244 },
	'cropangle' => { 347 => 'CropAngle' },
	'cropaspectratio' => { 84 => 0x260 },
	'cropbottom' => { 97 => 0x9, 207 => 0x36, 286 => 0xdc, 347 => 'CropBottom' },
	'cropbottommargin' => { 40 => 0x3 },
	'cropcircleactive' => { 85 => 0xd6 },
	'cropcircleradius' => { 85 => 0xd9 },
	'cropcirclex' => { 85 => 0xd7 },
	'cropcircley' => { 85 => 0xd8 },
	'cropconstraintowarp' => { 347 => 'CropConstrainToWarp' },
	'croph' => { 341 => 'CropH' },
	'cropheight' => { 84 => 0x24c, 233 => 0x615, 237 => 0x615, 347 => 'CropHeight' },
	'crophispeed' => { 179 => 0x1b },
	'cropleft' => { 84 => 0x246, 97 => 0x6, 207 => 0x1e, 233 => 0x612, 237 => 0x612, 286 => 0xd9, 347 => 'CropLeft' },
	'cropleftmargin' => { 40 => 0x0 },
	'cropoutputheight' => { 207 => 0xce },
	'cropoutputheightinches' => { 207 => 0x96 },
	'cropoutputpixels' => { 207 => 0xd6 },
	'cropoutputresolution' => { 207 => 0xb6 },
	'cropoutputscale' => { 207 => 0xbe },
	'cropoutputwidth' => { 207 => 0xc6 },
	'cropoutputwidthinches' => { 207 => 0x8e },
	'croppedareaimageheightpixels' => { 337 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 337 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 337 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 337 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimageleft' => { 3 => 0x3 },
	'croppedimagetop' => { 3 => 0x4 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 97 => 0x8, 207 => 0x2e, 286 => 0xdb, 347 => 'CropRight' },
	'croprightmargin' => { 40 => 0x1 },
	'croprotation' => { 97 => 0xb },
	'cropscaledresolution' => { 207 => 0x9e },
	'cropsourceresolution' => { 207 => 0xae },
	'croptop' => { 84 => 0x248, 97 => 0x7, 207 => 0x26, 233 => 0x613, 237 => 0x613, 286 => 0xda, 347 => 'CropTop' },
	'croptopmargin' => { 40 => 0x2 },
	'cropunit' => { 347 => 'CropUnit' },
	'cropunits' => { 347 => 'CropUnits' },
	'cropw' => { 341 => 'CropW' },
	'cropwidth' => { 84 => 0x24a, 233 => 0x614, 237 => 0x614, 347 => 'CropWidth' },
	'cropx' => { 341 => 'CropX' },
	'cropy' => { 341 => 'CropY' },
	'crossprocess' => { 279 => 0x7b },
	'crossprocessparams' => { 279 => 0x235 },
	'currenticcprofile' => { 93 => 0xc691 },
	'currentpreprofilematrix' => { 93 => 0xc692 },
	'currentversion' => { 333 => 0xd000 },
	'curve0x' => { 341 => 'Curve0x' },
	'curve0y' => { 341 => 'Curve0y' },
	'curve1x' => { 341 => 'Curve1x' },
	'curve1y' => { 341 => 'Curve1y' },
	'curve2x' => { 341 => 'Curve2x' },
	'curve2y' => { 341 => 'Curve2y' },
	'curve3x' => { 341 => 'Curve3x' },
	'curve3y' => { 341 => 'Curve3y' },
	'curve4x' => { 341 => 'Curve4x' },
	'curve4y' => { 341 => 'Curve4y' },
	'curves' => { 212 => 0x76a43201 },
	'custom1' => { 359 => 'Custom1' },
	'custom10' => { 359 => 'Custom10' },
	'custom2' => { 359 => 'Custom2' },
	'custom3' => { 359 => 'Custom3' },
	'custom4' => { 359 => 'Custom4' },
	'custom5' => { 359 => 'Custom5' },
	'custom6' => { 359 => 'Custom6' },
	'custom7' => { 359 => 'Custom7' },
	'custom8' => { 359 => 'Custom8' },
	'custom9' => { 359 => 'Custom9' },
	'customcontrast' => { 85 => 0x4e },
	'customcontrols' => { 66 => 0x70c },
	'customdefaultunsharpfineness' => { 85 => 0xbe },
	'customdefaultunsharpstrength' => { 85 => 0xbc },
	'customdefaultunsharpthreshold' => { 85 => 0xc0 },
	'customlinear' => { 85 => 0x4f },
	'customoutputhighlightpoint' => { 85 => 0x53 },
	'customoutputshadowpoint' => { 85 => 0x54 },
	'custompicturestylefilename' => { 49 => 0x4010 },
	'customrawhighlight' => { 85 => 0x7c },
	'customrawhighlightpoint' => { 85 => 0x51 },
	'customrawshadow' => { 85 => 0x85 },
	'customrawshadowpoint' => { 85 => 0x52 },
	'customrendered' => { 93 => 0xa401, 351 => 'CustomRendered' },
	'customsaturation' => { 229 => 0x503 },
	'customsettingsalldefault' => { 219 => '0.2', 224 => '0.2' },
	'customsettingsbank' => { 219 => '0.1', 224 => '0.1' },
	'customsharpness' => { 85 => 0x50 },
	'customunsharpmaskfineness' => { 85 => 0xb8 },
	'customunsharpmaskstrength' => { 85 => 0xb6 },
	'customunsharpmaskthreshold' => { 85 => 0xba },
	'customwb_rblevels' => { 322 => 0x1a },
	'customwb_rgblevels' => { 310 => 0x19 },
	'customwbbluelevel' => { 148 => 0x36 },
	'customwberror' => { 148 => 0x37 },
	'customwbgreenlevel' => { 148 => 0x35 },
	'customwbredlevel' => { 148 => 0x34 },
	'customwbsetting' => { 148 => 0x26 },
	'd-lightinghq' => { 212 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 208 => 0x2 },
	'd-lightinghqhighlight' => { 208 => 0x1 },
	'd-lightinghqselected' => { 212 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 208 => 0x0 },
	'd-lightinghs' => { 212 => 0xce5554aa },
	'd-lightinghsadjustment' => { 209 => 0x0 },
	'd-lightinghscolorboost' => { 209 => 0x1 },
	'd-rangeoptimizerhighlight' => { 333 => 0x8024 },
	'd-rangeoptimizermode' => { 333 => 0x8022 },
	'd-rangeoptimizershadow' => { 333 => 0x802d },
	'd-rangeoptimizervalue' => { 333 => 0x8023 },
	'datacompressionmethod' => { 103 => 0x6e },
	'dataimprint' => { 145 => 0x34 },
	'date' => { 279 => 0x6, 348 => 'date' },
	'dateacquired' => { 143 => 'DateAcquired' },
	'datecreated' => { 101 => 0x37, 358 => 'DateCreated' },
	'datedisplayformat' => { 204 => 0x3 },
	'dateidentified' => { 92 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 221 => '4.2' },
	'daterecieved' => { 360 => 'dateRecieved' },
	'datesent' => { 102 => 0x46 },
	'datestampmode' => { 49 => 0x1c },
	'datetime' => { 342 => 'datetime', 365 => 'DateTime' },
	'datetimedigitized' => { 351 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 82 => 0x0, 93 => 0x9003, 121 => 0x14, 124 => 'OriginalDate', 292 => 0xb, 351 => 'DateTimeOriginal' },
	'datetimestamp' => { 109 => 0x64 },
	'daylightsavings' => { 61 => 0x3, 204 => 0x2 },
	'dccontinent' => { 92 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 92 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 92 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 92 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 92 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 92 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 92 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 92 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 92 => 'Event' },
	'dcfootprintspatialfit' => { 92 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 92 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 92 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 92 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 92 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceprotocol' => { 92 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 92 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 92 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 92 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 92 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 92 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 92 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 92 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 92 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 92 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 92 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 92 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 92 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 92 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 92 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 92 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 92 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 92 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 92 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 92 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 92 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 92 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 92 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 92 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 132 => 'Declination' },
	'decposition' => { 145 => 0x32 },
	'defaultblackrender' => { 93 => 0xc7a6 },
	'defaultcroporigin' => { 93 => 0xc61f },
	'defaultcropsize' => { 93 => 0xc620 },
	'defaulteraseoption' => { 66 => 0x813 },
	'defaultscale' => { 93 => 0xc61e },
	'defaultusercrop' => { 93 => 0xc7b5 },
	'defringe' => { 347 => 'Defringe' },
	'defringegreenamount' => { 347 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 347 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 347 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 347 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 347 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 347 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 179 => 0xa6, 185 => 0x6e },
	'deprecatedon' => { 345 => 'deprecatedOn' },
	'derivedfrom' => { 370 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 370 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 370 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 370 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 370 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 370 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 370 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 370 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 370 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 370 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 370 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 370 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 370 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 370 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 370 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 370 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 370 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 370 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 240 => 'Description', 348 => 'description', 367 => 'Description' },
	'destination' => { 102 => 0x5 },
	'destinationcity' => { 279 => 0x24, 283 => 0x3 },
	'destinationcitycode' => { 284 => 0x1001 },
	'destinationdst' => { 279 => 0x26, 283 => '0.3' },
	'developmentdynamicrange' => { 98 => 0x1403 },
	'devicesettingdescription' => { 351 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 351 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 351 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 351 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 66 => 0x706 },
	'digitalcreationdate' => { 101 => 0x3e },
	'digitalcreationtime' => { 101 => 0x3f },
	'digitaldeehighlightadj' => { 184 => 0x202 },
	'digitaldeeshadowadj' => { 184 => 0x200 },
	'digitaldeethreshold' => { 184 => 0x201 },
	'digitalfilter' => { 304 => 0x59 },
	'digitalfilter01' => { 266 => 0x5 },
	'digitalfilter02' => { 266 => 0x16 },
	'digitalfilter03' => { 266 => 0x27 },
	'digitalfilter04' => { 266 => 0x38 },
	'digitalfilter05' => { 266 => 0x49 },
	'digitalfilter06' => { 266 => 0x5a },
	'digitalfilter07' => { 266 => 0x6b },
	'digitalfilter08' => { 266 => 0x7c },
	'digitalfilter09' => { 266 => 0x8d },
	'digitalfilter10' => { 266 => 0x9e },
	'digitalfilter11' => { 266 => 0xaf },
	'digitalfilter12' => { 266 => 0xc0 },
	'digitalfilter13' => { 266 => 0xd1 },
	'digitalfilter14' => { 266 => 0xe2 },
	'digitalfilter15' => { 266 => 0xf3 },
	'digitalfilter16' => { 266 => 0x104 },
	'digitalfilter17' => { 266 => 0x115 },
	'digitalfilter18' => { 266 => 0x126 },
	'digitalfilter19' => { 266 => 0x137 },
	'digitalfilter20' => { 266 => 0x148 },
	'digitalgain' => { 58 => 0xb },
	'digitalgem' => { 171 => 0x0 },
	'digitalice' => { 184 => 0x100 },
	'digitalimageguid' => { 356 => 'DigImageGUID' },
	'digitalroc' => { 183 => 0x0 },
	'digitalsourcefiletype' => { 356 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 356 => 'DigitalSourceType' },
	'digitalzoom' => { 27 => 0xc, 88 => 0xa, 109 => 0x68, 123 => 'DigitalZoom', 145 => 0xc, 179 => 0x86, 202 => 0xa, 234 => 0x204, 279 => 0x1e, 284 => 0xa, 303 => 0x204 },
	'digitalzoomon' => { 303 => 0x21b },
	'digitalzoomratio' => { 93 => 0xa404, 351 => 'DigitalZoomRatio' },
	'director' => { 369 => 'director' },
	'directorphotography' => { 369 => 'directorPhotography' },
	'directory' => { 94 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 6 => 0x2dc, 8 => 0x17e, 10 => 0x238, 11 => 0x13f, 12 => 0x133, 13 => 0x1df, 14 => 0x1a7, 15 => 0x1f0, 16 => 0xcc, 17 => 0x1c7, 18 => 0x298, 19 => 0x1e7, 20 => 0x1e5, 21 => 0x27c, 22 => 0x2b6, 23 => 0x1f7 },
	'directoryindex2' => { 18 => 0x29c },
	'directorynumber' => { 167 => 0x6 },
	'disclaimer' => { 240 => 'Disclaimer' },
	'displayallafpoints' => { 66 => 0x514 },
	'displayaperture' => { 27 => 0x23 },
	'displayedunitsx' => { 290 => 0x2 },
	'displayedunitsy' => { 290 => 0x6 },
	'distance1' => { 109 => 0x28 },
	'distance2' => { 109 => 0x2c },
	'distance3' => { 109 => 0x30 },
	'distance4' => { 109 => 0x34 },
	'distortioncontrol' => { 185 => 0x10 },
	'distortioncorrection' => { 85 => 0x67, 229 => 0x50b, 251 => '7.1', 269 => 0x0, 319 => 0x2013 },
	'distortioncorrection2' => { 233 => 0x1011 },
	'distortioncorrectionon' => { 85 => 0x63 },
	'distortionn' => { 251 => 0xc },
	'distortionparam02' => { 251 => 0x2 },
	'distortionparam04' => { 251 => 0x4 },
	'distortionparam08' => { 251 => 0x8 },
	'distortionparam09' => { 251 => 0x9 },
	'distortionparam11' => { 251 => 0xb },
	'distortionscale' => { 251 => 0x5 },
	'distributor' => { 360 => 'distributor' },
	'dloon' => { 85 => 0xdc },
	'dlosetting' => { 85 => 0xdd },
	'dlosettingapplied' => { 85 => 0xe4 },
	'dloshootingdistance' => { 85 => 0xde },
	'dloversion' => { 85 => 0xe5 },
	'dmcomment' => { 369 => 'comment' },
	'dngbackwardversion' => { 93 => 0xc613 },
	'dnglensinfo' => { 93 => 0xc630 },
	'dngversion' => { 93 => 0xc612 },
	'document' => { 240 => 'Document' },
	'documentancestorid' => { 358 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 358 => 'DocumentAncestors' },
	'documenthistory' => { 101 => 0xe7 },
	'documentid' => { 370 => 'DocumentID' },
	'documentname' => { 93 => 0x10d },
	'documentnotes' => { 101 => 0xe6 },
	'doi' => { 360 => 'doi' },
	'dotrange' => { 93 => 0x150 },
	'dpp' => { 342 => 'dpp' },
	'drivemode' => { 89 => 0x3103, 145 => 0x6, 148 => 0x1e, 151 => 0xe, 229 => 0x600, 279 => 0x34, 304 => 0x3, 308 => 0x4, 309 => 0x7e, 310 => 0x34 },
	'drivemode2' => { 148 => 0xa, 260 => 0x7, 318 => 0xe, 322 => 0x1 },
	'drivemodesetting' => { 310 => 0x4 },
	'dspfirmwareversion' => { 279 => 0x27 },
	'duration' => { 52 => 0x6a, 122 => 'Duration', 136 => 'Duration', 369 => 'duration' },
	'durationscale' => { 369 => [\'duration','durationScale'] },
	'durationvalue' => { 369 => [\'duration','durationValue'] },
	'dustremovaldata' => { 49 => 0x97 },
	'dynamicafarea' => { 219 => '1.4', 224 => '1.4' },
	'dynamicrange' => { 98 => 0x1400 },
	'dynamicrangeexpansion' => { 279 => 0x69 },
	'dynamicrangemax' => { 84 => 0x7c },
	'dynamicrangemin' => { 84 => 0x7a },
	'dynamicrangeoptimizer' => { 148 => 0x15, 319 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerbracket' => { 318 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 308 => 0x19, 309 => 0x17, 310 => 0xd, 322 => 0x5 },
	'dynamicrangeoptimizermode' => { 151 => 0x15, 308 => 0x18, 309 => 0x16, 318 => 0x15 },
	'dynamicrangeoptimizersetting' => { 148 => 0x27, 310 => 0xc, 322 => 0x4 },
	'dynamicrangesetting' => { 98 => 0x1402 },
	'e-dialinprogram' => { 260 => '1.3' },
	'earliestageorloweststage' => { 92 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 92 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 92 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 92 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 92 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 228 => '6.1' },
	'easyexposurecompensation' => { 219 => '6.4', 224 => '4.4', 225 => '5.2' },
	'easymode' => { 27 => 0xb },
	'edgenoisereduction' => { 213 => 0x4, 333 => 0x8028 },
	'edition' => { 360 => 'edition' },
	'editorialupdate' => { 101 => 0x8 },
	'editstatus' => { 101 => 0x7, 287 => 'EditStatus' },
	'editversionname' => { 212 => 0x3d136244 },
	'effectivelv' => { 279 => 0x2d },
	'effectivemaxaperture' => { 175 => 0x12, 176 => 0x13 },
	'eissn' => { 360 => 'eIssn' },
	'elevation' => { 132 => 'Elevation' },
	'email' => { 124 => 'EMail' },
	'embargodate' => { 360 => 'embargoDate', 362 => 'embargoDate' },
	'emissivity' => { 95 => 0x3 },
	'encryptionkey' => { 301 => 0xa020 },
	'endingpage' => { 360 => 'endingPage' },
	'enduser' => { 359 => 'EndUser' },
	'enduserid' => { 359 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 359 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 369 => 'engineer' },
	'enhancedarktones' => { 205 => 0x8 },
	'enhancement' => { 88 => 0x16, 89 => 0x3016 },
	'enhancer' => { 233 => 0x300 },
	'enhancervalues' => { 233 => 0x301 },
	'envelopenumber' => { 102 => 0x28 },
	'envelopepriority' => { 102 => 0x3c },
	'enveloperecordversion' => { 102 => 0x0 },
	'epsonimageheight' => { 234 => 0x20c },
	'epsonimagewidth' => { 234 => 0x20b },
	'epsonsoftware' => { 234 => 0x20d },
	'equipmentinstitution' => { 335 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 335 => 'EquipmentManufacturer' },
	'equipmentversion' => { 230 => 0x0 },
	'ettlii' => { 66 => 0x304, 67 => 0xd, 68 => 0xe, 69 => 0x7, 70 => 0x7, 71 => 0xe },
	'event' => { 340 => 'Event', 356 => 'Event', 360 => 'event' },
	'eventday' => { 92 => [\'Event','EventDay'] },
	'eventearliestdate' => { 92 => [\'Event','EventEarliestDate'] },
	'eventenddayofyear' => { 92 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 92 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 92 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 92 => [\'Event','EventHabitat'] },
	'eventid' => { 92 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 92 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 92 => [\'Event','EventMonth'] },
	'eventnumber' => { 292 => 0x9 },
	'eventremarks' => { 92 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 92 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 92 => [\'Event','EventSamplingProtocol'] },
	'eventstartdayofyear' => { 92 => [\'Event','EventStartDayOfYear'] },
	'eventtime' => { 92 => [\'Event','EventEventTime'] },
	'eventverbatimeventdate' => { 92 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 92 => [\'Event','EventYear'] },
	'evsteps' => { 260 => '1.2', 262 => 0x0 },
	'evstepsize' => { 221 => '5.1', 222 => '6.1', 223 => '6.1', 226 => '0.7' },
	'exclusivityenddate' => { 362 => 'exclusivityEndDate' },
	'excursiontolerance' => { 103 => 0x82 },
	'exif' => { 94 => 'EXIF' },
	'exifbyteorder' => { 94 => 'ExifByteOrder' },
	'exifcamerainfo' => { 101 => 0xe8 },
	'exifimageheight' => { 93 => 0xa003, 351 => 'PixelYDimension' },
	'exifimagewidth' => { 93 => 0xa002, 351 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 94 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 93 => 0x9000, 351 => 'ExifVersion' },
	'exitpupilposition' => { 175 => 0x4, 176 => 0x4 },
	'expirationdate' => { 101 => 0x25, 360 => 'expirationDate', 362 => 'expirationDate' },
	'expirationtime' => { 101 => 0x26 },
	'exposure' => { 93 => 0xfe51, 347 => 'Exposure' },
	'exposure2012' => { 347 => 'Exposure2012' },
	'exposureadj' => { 210 => 0x0 },
	'exposureadj2' => { 210 => 0x12 },
	'exposureadjust' => { 304 => 0xc },
	'exposurebracketingindicatorlast' => { 148 => 0x52 },
	'exposurebracketshotnumber' => { 151 => 0x2d, 318 => 0x2f },
	'exposurebracketstepsize' => { 260 => 0x8 },
	'exposurebracketvalue' => { 179 => 0x19 },
	'exposurecompensation' => { 60 => 0x6, 75 => 0x0, 93 => 0x9204, 109 => 0x24, 123 => 'ExposureComp', 145 => 0xd, 146 => 0x53, 147 => 0x1e, 151 => 0x49c0, 234 => 0x1006, 279 => 0x16, 301 => 0xa013, 304 => [0xc,0x35,0x4d], 351 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 322 => 0x2a },
	'exposurecompensationmode' => { 148 => 0x47, 151 => 0x2a },
	'exposurecompensationset' => { 310 => 0x3, 322 => 0x1e },
	'exposurecompensationsetting' => { 148 => 0x1 },
	'exposurecompstepsize' => { 219 => '6.3', 224 => '4.3' },
	'exposurecontrolstep' => { 225 => '6.1' },
	'exposurecontrolstepsize' => { 219 => '6.2', 224 => '4.2', 228 => '7.1' },
	'exposuredelaymode' => { 219 => '10.1', 221 => '9.1', 222 => '10.1', 223 => '10.1', 224 => '10.4', 225 => '10.1', 226 => '6.4', 228 => '11.2' },
	'exposuredifference' => { 179 => 0xe },
	'exposureindex' => { 93 => 0xa215, 351 => 'ExposureIndex' },
	'exposureindicator' => { 148 => 0x50 },
	'exposurelevelincrements' => { 64 => 0x6, 65 => 0x6, 66 => 0x101, 67 => 0x5, 68 => 0x6, 69 => 0x5, 70 => 0x5, 71 => 0x6, 72 => 0x4, 308 => 0x58, 309 => 0x58 },
	'exposurelockused' => { 337 => 'ExposureLockUsed' },
	'exposuremode' => { 93 => 0xa402, 123 => 'ExposureMode', 145 => 0x1, 146 => 0xa, 147 => 0x0, 148 => 0x0, 151 => 0x34, 229 => 0x200, 246 => 0x40d, 304 => 0x8, 319 => 0xb041, 351 => 'ExposureMode' },
	'exposuremodeinmanual' => { 66 => 0x10b },
	'exposureprogram' => { 93 => 0x8822, 305 => 0x17e, 308 => 0x3c, 309 => 0x3c, 310 => 0x5, 314 => 0x14, 318 => 0x3f, 322 => 0x2, 351 => 'ExposureProgram' },
	'exposureshift' => { 229 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x6, 25 => 0x7, 60 => 0x16, 93 => 0x829a, 106 => 0xfd05, 109 => 0x20, 111 => 0xfa24, 113 => 0xf104, 116 => 0x12, 118 => 0x38, 121 => 0x10, 123 => 'ExposureTime', 145 => 0x9, 146 => 0x35, 147 => 0x48, 148 => 0x8, 151 => 0x49b8, 279 => 0x12, 301 => 0xa018, 304 => [0x32,0x4a], 308 => 0x0, 309 => 0x0, 322 => 0x27, 351 => 'ExposureTime' },
	'exposuretime2' => { 304 => [0x33,0x4b] },
	'exposuretuning' => { 179 => 0x1c },
	'exposurevalue' => { 107 => 0x3 },
	'exposurewarning' => { 98 => 0x1302 },
	'exrauto' => { 98 => 0x1033 },
	'exrmode' => { 98 => 0x1034 },
	'extendedwbdetect' => { 229 => 0x902 },
	'extender' => { 230 => 0x301 },
	'extenderfirmwareversion' => { 230 => 0x304 },
	'extendermagnification' => { 125 => 'Magnification' },
	'extendermake' => { 125 => 'Make' },
	'extendermodel' => { 125 => 'Model', 230 => 0x303 },
	'extenderserialnumber' => { 125 => 'SerialNumber', 230 => 0x302 },
	'externalflash' => { 232 => 0x1201 },
	'externalflashae1' => { 234 => 0x101f },
	'externalflashae1_0' => { 234 => 0x101b },
	'externalflashae2' => { 234 => 0x1020 },
	'externalflashae2_0' => { 234 => 0x101c },
	'externalflashbounce' => { 232 => 0x1204, 234 => 0x1026, 267 => 0x1a },
	'externalflashcompensation' => { 170 => 0x1b },
	'externalflashexposurecomp' => { 179 => 0x17, 267 => 0x19 },
	'externalflashfirmware' => { 168 => 0x6, 169 => 0x6, 170 => 0x6 },
	'externalflashflags' => { 168 => 0x8, 169 => 0x8, 170 => 0x8 },
	'externalflashguidenumber' => { 232 => 0x1203, 267 => '24.1' },
	'externalflashgvalue' => { 234 => 0x1025 },
	'externalflashmode' => { 234 => 0x1028, 267 => 0x2 },
	'externalflashzoom' => { 232 => 0x1205, 234 => 0x1027 },
	'externalsensorbrightnessvalue' => { 244 => 0x311, 250 => 0x3408 },
	'extrainfoversion' => { 312 => 0x1a },
	'eyestartaf' => { 148 => 0x40 },
	'face10position' => { 86 => 0x3f4, 87 => 0x1ec, 166 => 0x28, 264 => 0x12 },
	'face10size' => { 265 => 0x12 },
	'face11position' => { 166 => 0x2c, 264 => 0x14 },
	'face11size' => { 265 => 0x14 },
	'face12position' => { 166 => 0x30, 264 => 0x16 },
	'face12size' => { 265 => 0x16 },
	'face13position' => { 264 => 0x18 },
	'face13size' => { 265 => 0x18 },
	'face14position' => { 264 => 0x1a },
	'face14size' => { 265 => 0x1a },
	'face15position' => { 264 => 0x1c },
	'face15size' => { 265 => 0x1c },
	'face16position' => { 264 => 0x1e },
	'face16size' => { 265 => 0x1e },
	'face17position' => { 264 => 0x20 },
	'face17size' => { 265 => 0x20 },
	'face18position' => { 264 => 0x22 },
	'face18size' => { 265 => 0x22 },
	'face19position' => { 264 => 0x24 },
	'face19size' => { 265 => 0x24 },
	'face1position' => { 41 => 0x8, 86 => 0xd, 87 => 0x18, 166 => 0x4, 242 => 0x1, 264 => 0x0, 293 => 0xbc, 315 => 0x1, 316 => 0x0, 317 => 0x0 },
	'face1size' => { 265 => 0x0 },
	'face20position' => { 264 => 0x26 },
	'face20size' => { 265 => 0x26 },
	'face21position' => { 264 => 0x28 },
	'face21size' => { 265 => 0x28 },
	'face22position' => { 264 => 0x2a },
	'face22size' => { 265 => 0x2a },
	'face23position' => { 264 => 0x2c },
	'face23size' => { 265 => 0x2c },
	'face24position' => { 264 => 0x2e },
	'face24size' => { 265 => 0x2e },
	'face25position' => { 264 => 0x30 },
	'face25size' => { 265 => 0x30 },
	'face26position' => { 264 => 0x32 },
	'face26size' => { 265 => 0x32 },
	'face27position' => { 264 => 0x34 },
	'face27size' => { 265 => 0x34 },
	'face28position' => { 264 => 0x36 },
	'face28size' => { 265 => 0x36 },
	'face29position' => { 264 => 0x38 },
	'face29size' => { 265 => 0x38 },
	'face2position' => { 41 => 0xa, 86 => 0x7c, 87 => 0x4c, 166 => 0x8, 242 => 0x5, 264 => 0x2, 293 => 0xc8, 315 => 0x6, 316 => 0x20, 317 => 0x25 },
	'face2size' => { 265 => 0x2 },
	'face30position' => { 264 => 0x3a },
	'face30size' => { 265 => 0x3a },
	'face31position' => { 264 => 0x3c },
	'face31size' => { 265 => 0x3c },
	'face32position' => { 264 => 0x3e },
	'face32size' => { 265 => 0x3e },
	'face3position' => { 41 => 0xc, 86 => 0xeb, 87 => 0x80, 166 => 0xc, 242 => 0x9, 264 => 0x4, 293 => 0xd4, 315 => 0xb, 316 => 0x40, 317 => 0x4a },
	'face3size' => { 265 => 0x4 },
	'face4position' => { 41 => 0xe, 86 => 0x15a, 87 => 0xb4, 166 => 0x10, 242 => 0xd, 264 => 0x6, 293 => 0xe0, 315 => 0x10, 316 => 0x60, 317 => 0x6f },
	'face4size' => { 265 => 0x6 },
	'face5position' => { 41 => 0x10, 86 => 0x1c9, 87 => 0xe8, 166 => 0x14, 242 => 0x11, 264 => 0x8, 293 => 0xec, 315 => 0x15, 316 => 0x80, 317 => 0x94 },
	'face5size' => { 265 => 0x8 },
	'face6position' => { 41 => 0x12, 86 => 0x238, 87 => 0x11c, 166 => 0x18, 264 => 0xa, 293 => 0xf8, 315 => 0x1a, 316 => 0xa0, 317 => 0xb9 },
	'face6size' => { 265 => 0xa },
	'face7position' => { 41 => 0x14, 86 => 0x2a7, 87 => 0x150, 166 => 0x1c, 264 => 0xc, 293 => 0x104, 315 => 0x1f, 316 => 0xc0, 317 => 0xde },
	'face7size' => { 265 => 0xc },
	'face8position' => { 41 => 0x16, 86 => 0x316, 87 => 0x184, 166 => 0x20, 264 => 0xe, 293 => 0x110, 315 => 0x24, 316 => 0xe0, 317 => 0x103 },
	'face8size' => { 265 => 0xe },
	'face9position' => { 41 => 0x18, 86 => 0x385, 87 => 0x1b8, 166 => 0x24, 264 => 0x10 },
	'face9size' => { 265 => 0x10 },
	'facedetect' => { 279 => 0x76 },
	'facedetectarea' => { 233 => 0x1201 },
	'facedetectframecrop' => { 233 => 0x1207 },
	'facedetectframesize' => { 41 => 0x3, 86 => 0x1, 87 => 0x4, 166 => 0x1, 233 => 0x1203, 279 => 0x77, 293 => 0xb6 },
	'facedetection' => { 310 => 0x30, 322 => 0x19 },
	'faceid' => { 343 => 'FaceID' },
	'faceinfounknown' => { 89 => 0x2089 },
	'faceorientation' => { 87 => 0x8 },
	'faceposition' => { 263 => 0x2, 302 => 0x4 },
	'facepositions' => { 98 => 0x4103 },
	'facesdetected' => { 41 => 0x2, 42 => 0x2, 43 => 0x3, 86 => 0x0, 87 => 0x2, 89 => 0x211c, 98 => 0x4100, 166 => 0x3, 233 => 0x1200, 248 => 0x3f, 263 => 0x0, 293 => 0xb5, 302 => 0x0, 315 => 0x0, 324 => 0x30 },
	'facesrecognized' => { 243 => 0x0 },
	'facewidth' => { 42 => 0x1 },
	'faithfuloutputhighlightpoint' => { 85 => 0x38 },
	'faithfuloutputshadowpoint' => { 85 => 0x39 },
	'faithfulrawcolortone' => { 85 => 0x31 },
	'faithfulrawcontrast' => { 85 => 0x33 },
	'faithfulrawhighlight' => { 85 => 0x79 },
	'faithfulrawhighlightpoint' => { 85 => 0x36 },
	'faithfulrawlinear' => { 85 => 0x34 },
	'faithfulrawsaturation' => { 85 => 0x32 },
	'faithfulrawshadow' => { 85 => 0x82 },
	'faithfulrawshadowpoint' => { 85 => 0x37 },
	'faithfulrawsharpness' => { 85 => 0x35 },
	'faithfulunsharpmaskfineness' => { 85 => 0xac },
	'faithfulunsharpmaskstrength' => { 85 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 85 => 0xae },
	'femicroadjustment' => { 66 => 0x110 },
	'ffid' => { 349 => 'ffid' },
	'fieldcount' => { 234 => 0x103f },
	'filecreatedate' => { 94 => 'FileCreateDate' },
	'filedatarate' => { 369 => 'fileDataRate' },
	'fileformat' => { 77 => 0x0, 102 => 0x14, 304 => [0x22,0x26], 319 => 0xb000 },
	'fileindex' => { 4 => 0x143, 6 => 0x2d0, 8 => 0x172, 10 => 0x22c, 11 => 0x133, 12 => 0x13f, 13 => 0x1d3, 14 => 0x19b, 15 => 0x1e4, 16 => 0xd0, 17 => 0x1bb, 18 => 0x28c, 19 => 0x1db, 20 => 0x1d9, 21 => 0x270, 22 => 0x2aa, 23 => 0x1eb, 249 => 0x0 },
	'fileindex2' => { 18 => 0x290 },
	'filemodifydate' => { 94 => 'FileModifyDate' },
	'filename' => { 94 => 'FileName' },
	'filenameasdelivered' => { 359 => 'FileNameAsDelivered' },
	'filenumber' => { 44 => 0x1, 49 => 0x8, 79 => 0x1817, 90 => 'FileNumber', 167 => 0x8 },
	'filenumbermemory' => { 145 => 0x1a },
	'filenumbersequence' => { 219 => '12.2', 221 => '3.1', 222 => '4.1', 223 => '4.1', 224 => '11.1', 225 => '4.3', 228 => '5.2' },
	'filesource' => { 93 => 0xa300, 98 => 0x8000, 351 => 'FileSource' },
	'fileversion' => { 102 => 0x16 },
	'fillflashautoreduction' => { 64 => 0xe, 65 => 0xe, 72 => 0xa },
	'filllight' => { 347 => 'FillLight' },
	'fillorder' => { 93 => 0x10a },
	'filmmode' => { 98 => 0x1401, 246 => 0x412, 248 => 0x42 },
	'filmtype' => { 184 => 0x2 },
	'filtereffect' => { 44 => 0xe, 181 => 0x37 },
	'filtereffectfaithful' => { 54 => 0x70, 55 => 0x70 },
	'filtereffectlandscape' => { 54 => 0x40, 55 => 0x40 },
	'filtereffectmonochrome' => { 16 => 0xff, 54 => 0x88, 55 => 0x88 },
	'filtereffectneutral' => { 54 => 0x58, 55 => 0x58 },
	'filtereffectportrait' => { 54 => 0x28, 55 => 0x28 },
	'filtereffectstandard' => { 54 => 0x10, 55 => 0x10 },
	'filtereffectunknown' => { 55 => 0xa0 },
	'filtereffectuserdef1' => { 54 => 0xa0, 55 => 0xb8 },
	'filtereffectuserdef2' => { 54 => 0xb8, 55 => 0xd0 },
	'filtereffectuserdef3' => { 54 => 0xd0, 55 => 0xe8 },
	'finderdisplayduringexposure' => { 65 => 0x1 },
	'finesharpness' => { 279 => 0x70 },
	'finetuneoptcenterweighted' => { 219 => '7.2', 228 => '9.1' },
	'finetuneoptmatrixmetering' => { 219 => '8.1', 224 => '6.1', 228 => '8.2' },
	'finetuneoptspotmetering' => { 219 => '8.2', 224 => '6.2', 228 => '9.2' },
	'firmware' => { 234 => 0x405, 304 => [0x17,0x3b,0x57], 344 => 'Firmware' },
	'firmwaredate' => { 88 => 0x15, 89 => 0x2001, 292 => 0x4 },
	'firmwareid' => { 152 => 0x0 },
	'firmwarename' => { 301 => 0xa001 },
	'firmwarerevision' => { 16 => 0xa4, 49 => 0x1e, 294 => 0x0 },
	'firmwarerevision2' => { 294 => 0xc },
	'firmwareversion' => { 4 => 0x10b, 8 => 0x136, 11 => 0xff, 12 => 0x107, 107 => 0xce5, 121 => 0x57, 123 => 'FirmwareVersion', 248 => 0x2, 250 => 0x3109, 279 => 0x230, 296 => 0x2 },
	'firstphotodate' => { 337 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 359 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 101 => 0x16 },
	'flash' => { 90 => 'Flash', 93 => 0x9209, 146 => 0x1f, 147 => 0x15, 351 => 'Flash' },
	'flashaction' => { 310 => [0x87,0x287] },
	'flashaction2' => { 322 => 0x30 },
	'flashactivity' => { 27 => 0x1c },
	'flashbatterylevel' => { 33 => 0x249 },
	'flashbias' => { 248 => 0x24 },
	'flashbits' => { 27 => 0x1d },
	'flashbuttonfunction' => { 66 => 0x70e },
	'flashchargelevel' => { 234 => 0x1010 },
	'flashcolorfilter' => { 170 => 0x10 },
	'flashcommandermode' => { 168 => '9.1', 169 => '9.1', 170 => '9.1' },
	'flashcompensation' => { 168 => 0xa, 169 => 0xa, 170 => 0xa, 344 => 'FlashCompensation' },
	'flashcontrol' => { 310 => 0x21 },
	'flashcontrolbuilt-in' => { 224 => '16.1', 225 => '23.1', 227 => '23.1' },
	'flashcontrolmode' => { 168 => '9.2', 169 => '9.2', 170 => '9.2', 229 => 0x404 },
	'flashcurtain' => { 248 => 0x48 },
	'flashdefault' => { 148 => 0x42 },
	'flashdevice' => { 234 => 0x1005 },
	'flashdistance' => { 89 => 0x2034 },
	'flashenergy' => { 93 => 0xa20b, 351 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 179 => 0x18 },
	'flashexposurecomp' => { 60 => 0xf, 98 => 0x1011, 126 => 'ExposureComp', 145 => 0x23, 150 => 0x104, 151 => 0x49c1, 179 => 0x12, 229 => 0x401, 234 => 0x1023, 279 => 0x4d, 304 => [0x3a,0x56], 319 => 0x104 },
	'flashexposurecomp2' => { 200 => 0x4d2 },
	'flashexposurecomp3' => { 170 => 0x1d },
	'flashexposurecomp4' => { 170 => 0x27 },
	'flashexposurecompset' => { 148 => 0x10, 253 => 0xe, 310 => 0x23, 322 => 0x1f },
	'flashexposurecompset2' => { 322 => 0x2c },
	'flashexposureindicator' => { 148 => 0x54 },
	'flashexposureindicatorlast' => { 148 => 0x56 },
	'flashexposureindicatornext' => { 148 => 0x55 },
	'flashexposurelock' => { 44 => 0x19 },
	'flashfired' => { 109 => 0x5d, 126 => 'Fired', 145 => 0x14, 199 => '590.3', 248 => 0x8007, 351 => [\'Flash','FlashFired'] },
	'flashfiring' => { 66 => 0x306, 67 => 0x6, 68 => 0x7, 71 => 0x7 },
	'flashfirmwareversion' => { 230 => 0x1002 },
	'flashfocallength' => { 168 => 0xb, 169 => 0xc, 170 => 0xc },
	'flashfunction' => { 151 => 0x31, 351 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 168 => 0xe, 169 => 0xf, 170 => 0xf },
	'flashgroupacompensation' => { 168 => 0x11, 169 => 0x12, 170 => 0x13 },
	'flashgroupacontrolmode' => { 168 => 0xf, 169 => '16.1', 170 => '17.1' },
	'flashgroupaoutput' => { 168 => 0x11, 169 => 0x12, 170 => 0x13 },
	'flashgroupbcompensation' => { 168 => 0x12, 169 => 0x13, 170 => 0x14 },
	'flashgroupbcontrolmode' => { 168 => 0x10, 169 => '17.1', 170 => '18.1' },
	'flashgroupboutput' => { 168 => 0x12, 169 => 0x13, 170 => 0x14 },
	'flashgroupccompensation' => { 169 => 0x14, 170 => 0x15 },
	'flashgroupccontrolmode' => { 169 => '17.2', 170 => '18.2' },
	'flashgroupcoutput' => { 169 => 0x14, 170 => 0x15 },
	'flashguidenumber' => { 60 => 0xd, 76 => 0x0, 126 => 'GuideNumber' },
	'flashintensity' => { 88 => [0x19,0x5], 229 => 0x405 },
	'flashlevel' => { 220 => 0x9, 319 => 0xb048 },
	'flashmake' => { 126 => 'Make' },
	'flashmanufacturer' => { 143 => 'FlashManufacturer' },
	'flashmetering' => { 145 => 0x3f, 148 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 17 => 0x15, 19 => 0x15, 23 => 0x15 },
	'flashmeteringsegments' => { 279 => 0x20a },
	'flashmode' => { 88 => 0x4, 109 => 0x5c, 126 => 'Mode', 145 => 0x2, 146 => 0x20, 147 => 0x16, 148 => 0xf, 179 => 0x87, 229 => 0x400, 234 => 0x1004, 279 => 0xc, 284 => 0x4, 295 => 0x20, 303 => 0x225, 308 => 0x23, 309 => 0x1f, 310 => 0x20, 322 => 0x10, 351 => [\'Flash','FlashMode'] },
	'flashmodel' => { 126 => 'Model', 143 => 'FlashModel', 230 => 0x1001 },
	'flashoptions' => { 260 => 0x2 },
	'flashoptions2' => { 260 => 0x10 },
	'flashoutput' => { 33 => 0x248, 60 => 0x21, 168 => 0xa, 169 => 0xa, 170 => 0xa },
	'flashpixversion' => { 93 => 0xa000, 351 => 'FlashpixVersion' },
	'flashredeyemode' => { 351 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 229 => 0x403 },
	'flashreturn' => { 351 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 126 => 'SerialNumber', 230 => 0x1003 },
	'flashsetting' => { 179 => 0x8 },
	'flashshutterspeed' => { 219 => '20.2', 224 => '15.2', 225 => '22.2', 226 => '7.2', 227 => '22.2', 228 => '23.1' },
	'flashsource' => { 168 => 0x4, 169 => 0x4, 170 => 0x4 },
	'flashstatus' => { 267 => 0x0, 325 => 0x31 },
	'flashsyncspeed' => { 219 => '20.1', 224 => '15.1', 225 => '22.1', 227 => '22.1' },
	'flashsyncspeedav' => { 64 => 0x3, 66 => 0x10f, 67 => 0x2, 68 => 0x3, 69 => 0x2, 70 => 0x2, 71 => 0x3, 72 => 0x6 },
	'flashthreshold' => { 76 => 0x1 },
	'flashtype' => { 126 => 'Type', 148 => 0x59, 179 => 0x9, 230 => 0x1000 },
	'flashwarning' => { 225 => '30.1', 226 => '7.1', 228 => '31.1', 248 => 0x62 },
	'flexiblespotposition' => { 319 => 0x201d },
	'flickerreduce' => { 303 => 0x218 },
	'fliphorizontal' => { 212 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 6 => 0x3, 8 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x5, 25 => 0x6, 60 => 0x15, 93 => 0x829d, 106 => 0xfd04, 109 => 0x1e, 111 => 0xfa23, 113 => 0xf103, 116 => 0x13, 118 => 0x3c, 121 => 0xc, 130 => 'FNumber', 145 => 0xa, 146 => 0x36, 147 => 0x47, 148 => 0x9, 151 => 0x49c7, 279 => 0x13, 301 => 0xa019, 304 => [0x31,0x49], 308 => 0x1, 309 => 0x1, 322 => 0x26, 351 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x23, 7 => 0x9, 8 => 0x1d, 9 => 0x9, 10 => 0x1e, 11 => 0x1d, 12 => 0x1d, 13 => 0x1e, 14 => 0x1e, 15 => 0x1e, 16 => 0x28, 17 => 0x1e, 18 => 0x23, 19 => 0x1e, 20 => 0x1e, 21 => 0x20, 22 => 0x23, 23 => 0x1e, 46 => 0x1, 89 => 0x1d, 93 => 0x920a, 116 => 0x1d, 130 => 'FocalLength', 145 => 0x12, 175 => 0xa, 176 => 0xb, 270 => 0x9, 279 => 0x1d, 306 => 0xe, 351 => 'FocalLength' },
	'focallengthin35mmformat' => { 93 => 0xa405, 301 => 0xa01a, 351 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 306 => 0x10 },
	'focalplanediagonal' => { 230 => 0x103, 234 => 0x205 },
	'focalplaneresolutionunit' => { 93 => 0xa210, 351 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 93 => 0xa20e, 351 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 46 => 0x2 },
	'focalplanexunknown' => { 46 => 0x2 },
	'focalplaneyresolution' => { 93 => 0xa20f, 351 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 46 => 0x3 },
	'focalplaneyunknown' => { 46 => 0x3 },
	'focaltype' => { 7 => 0x2d, 46 => 0x0 },
	'focalunits' => { 27 => 0x19 },
	'focus' => { 202 => 0x8 },
	'focusarea' => { 145 => 0x31 },
	'focusareaselection' => { 226 => '15.2' },
	'focuscontinuous' => { 27 => 0x20 },
	'focusdisplayaiservoandmf' => { 66 => 0x515 },
	'focusdistance' => { 130 => 'FocusDistance', 145 => 0x13, 151 => 0x49bb, 175 => 0x9, 176 => 0xa, 232 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 6 => 0x8e, 8 => 0x45, 10 => 0x56, 11 => 0x45, 12 => 0x45, 13 => 0x52, 14 => 0x52, 15 => 0x56, 17 => 0x52, 18 => 0x8e, 19 => 0x59, 20 => 0x57, 21 => 0x8e, 22 => 0x94, 23 => 0x56, 60 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 6 => 0x8c, 8 => 0x43, 10 => 0x54, 11 => 0x43, 12 => 0x43, 13 => 0x50, 14 => 0x50, 15 => 0x54, 17 => 0x50, 18 => 0x8c, 19 => 0x57, 20 => 0x55, 21 => 0x8c, 22 => 0x92, 23 => 0x54, 60 => 0x13 },
	'focusholdbutton' => { 148 => 0x44 },
	'focusinfoversion' => { 232 => 0x0 },
	'focusingscreen' => { 65 => 0x0, 66 => 0x80b, 71 => 0x0 },
	'focuslocked' => { 144 => 0x14 },
	'focusmode' => { 27 => 0x7, 88 => 0x3, 89 => [0x3003,0xd], 98 => 0x1021, 109 => 0x38, 123 => 'FocusMode', 145 => 0x30, 147 => 0xe, 148 => 0xc, 179 => 0x7, 229 => 0x301, 234 => 0x100b, 248 => 0x7, 279 => 0xd, 284 => 0x3, 305 => 0xb, 306 => 0x1d, 308 => 0x4d, 309 => 0x4d, 319 => [0xb042,0xb04e,0x201b], 322 => 0x13 },
	'focusmode2' => { 260 => '3.1', 322 => 0x32 },
	'focusmodesetting' => { 220 => '10.1', 308 => 0x10, 309 => 0xf, 310 => 0x6 },
	'focusmodeswitch' => { 148 => 0x58, 308 => 0x2e },
	'focuspixel' => { 98 => 0x1023 },
	'focuspointwrap' => { 219 => '2.2', 224 => '2.2', 225 => '1.2', 228 => '2.5' },
	'focusposition' => { 175 => 0x8, 176 => 0x8, 279 => 0x10, 318 => 0x9bb },
	'focusprocess' => { 229 => 0x302 },
	'focusrange' => { 27 => 0x12, 234 => 0x100a },
	'focussetting' => { 304 => 0x6 },
	'focusstatus' => { 306 => 0x19, 308 => 0x53, 309 => 0x53 },
	'focusstepcount' => { 232 => 0x301, 234 => 0x100e },
	'focusstepinfinity' => { 232 => 0x303, 234 => 0x103b },
	'focusstepnear' => { 232 => 0x304, 234 => 0x103c },
	'focustrackinglockon' => { 219 => ['1.5','4.1'], 224 => '3.1', 225 => '0.4' },
	'focuswarning' => { 98 => 0x1301 },
	'foldername' => { 145 => 0x27 },
	'fontcomposite' => { 374 => [\'Fonts','FontsComposite'] },
	'fontface' => { 374 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 374 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 374 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 374 => [\'Fonts','FontsFontName'] },
	'fonts' => { 374 => 'Fonts' },
	'fonttype' => { 374 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 374 => [\'Fonts','FontsVersionString'] },
	'for' => { 291 => 'For' },
	'format' => { 348 => 'format', 367 => 'Format' },
	'forwardlock' => { 364 => 'forwardlock' },
	'forwardmatrix1' => { 93 => 0xc714 },
	'forwardmatrix2' => { 93 => 0xc715 },
	'framecount' => { 52 => [0x2,0x4] },
	'framenum' => { 286 => 0xd7 },
	'framenumber' => { 98 => 0x8003, 151 => 0x3c, 279 => 0x29 },
	'framerate' => { 52 => [0x1,0x6], 93 => 0xc764 },
	'freebytes' => { 79 => 0x1 },
	'freememorycardimages' => { 146 => [0x37,0x54], 147 => [0x2d,0x4a], 148 => 0x32 },
	'fujiflashmode' => { 98 => 0x1010 },
	'fullimagesize' => { 319 => 0xb02b },
	'fullpanoheightpixels' => { 337 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 337 => 'FullPanoWidthPixels' },
	'fullsizeimage' => { 129 => 'data' },
	'fullsizeimagename' => { 129 => '1Name' },
	'fullsizeimagetype' => { 129 => '0Type' },
	'funcbutton' => { 219 => ['14.1','15.1'], 224 => '28.1', 225 => '13.1', 228 => '14.1' },
	'funcbuttonplusdials' => { 219 => ['14.2','15.2'], 224 => '31.1' },
	'functionbutton' => { 223 => '13.1', 226 => '5.2' },
	'gainbase' => { 233 => 0x610 },
	'gaincontrol' => { 93 => 0xa407, 351 => 'GainControl' },
	'gamma' => { 93 => 0xa500 },
	'gammacompensatedvalue' => { 103 => 0x91 },
	'geimagesize' => { 98 => 0x1304 },
	'gemake' => { 99 => 0x300 },
	'gemodel' => { 99 => 0x207 },
	'genre' => { 360 => 'genre', 369 => 'genre' },
	'geography' => { 361 => 'geography' },
	'geologicalcontext' => { 92 => 'GeologicalContext' },
	'geologicalcontextbed' => { 92 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 92 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 92 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 92 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 92 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 94 => 'Geosync' },
	'geotag' => { 94 => 'Geotag' },
	'geotime' => { 94 => 'Geotime' },
	'globalaltitude' => { 289 => 0x419 },
	'globalangle' => { 289 => 0x40d },
	'good' => { 369 => 'good' },
	'gpsaltitude' => { 100 => 0x6, 127 => 'Altitude', 351 => 'GPSAltitude' },
	'gpsaltituderef' => { 100 => 0x5, 351 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 100 => 0x1c, 351 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 100 => 0x1d },
	'gpsdatetime' => { 127 => 'DateTime', 351 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 100 => 0x18, 127 => 'Bearing', 351 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 100 => 0x17, 351 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 100 => 0x1a, 127 => 'Distance', 351 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 100 => 0x19, 351 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 100 => 0x14, 351 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 100 => 0x13 },
	'gpsdestlongitude' => { 100 => 0x16, 351 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 100 => 0x15 },
	'gpsdifferential' => { 100 => 0x1e, 127 => 'Differential', 351 => 'GPSDifferential' },
	'gpsdop' => { 100 => 0xb, 351 => 'GPSDOP' },
	'gpshpositioningerror' => { 100 => 0x1f },
	'gpsimgdirection' => { 100 => 0x11, 351 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 100 => 0x10, 351 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 100 => 0x2, 127 => 'Latitude', 351 => 'GPSLatitude' },
	'gpslatituderef' => { 100 => 0x1 },
	'gpslongitude' => { 100 => 0x4, 127 => 'Longitude', 351 => 'GPSLongitude' },
	'gpslongituderef' => { 100 => 0x3 },
	'gpsmapdatum' => { 100 => 0x12, 127 => 'Datum', 351 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 100 => 0xa, 127 => 'MeasureMode', 351 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 100 => 0x1b, 351 => 'GPSProcessingMethod' },
	'gpssatellites' => { 100 => 0x8, 127 => 'Satellites', 351 => 'GPSSatellites' },
	'gpsspeed' => { 100 => 0xd, 127 => 'Speed', 351 => 'GPSSpeed' },
	'gpsspeedref' => { 100 => 0xc, 351 => 'GPSSpeedRef' },
	'gpsstatus' => { 100 => 0x9, 351 => 'GPSStatus' },
	'gpstimestamp' => { 100 => 0x7 },
	'gpstrack' => { 100 => 0xf, 127 => 'Heading', 351 => 'GPSTrack' },
	'gpstrackref' => { 100 => 0xe, 351 => 'GPSTrackRef' },
	'gpsversionid' => { 100 => 0x0, 351 => 'GPSVersionID' },
	'gradation' => { 229 => 0x50f },
	'gradientbasedcorractive' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 347 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskcenterweight' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskflow' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskradius' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmasks' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmaskvalue' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskwhat' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskzerox' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 347 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 347 => 'GrainAmount' },
	'grainfrequency' => { 347 => 'GrainFrequency' },
	'grainsize' => { 347 => 'GrainSize' },
	'graymixeraqua' => { 347 => 'GrayMixerAqua' },
	'graymixerblue' => { 347 => 'GrayMixerBlue' },
	'graymixergreen' => { 347 => 'GrayMixerGreen' },
	'graymixermagenta' => { 347 => 'GrayMixerMagenta' },
	'graymixerorange' => { 347 => 'GrayMixerOrange' },
	'graymixerpurple' => { 347 => 'GrayMixerPurple' },
	'graymixerred' => { 347 => 'GrayMixerRed' },
	'graymixeryellow' => { 347 => 'GrayMixerYellow' },
	'graypoint' => { 333 => 0x8021 },
	'grayresponseunit' => { 93 => 0x122 },
	'greencurvelimits' => { 84 => 0x1c4 },
	'greencurvepoints' => { 84 => 0x19a },
	'greenhue' => { 347 => 'GreenHue' },
	'greensaturation' => { 347 => 'GreenSaturation' },
	'griddisplay' => { 219 => '13.3', 221 => '2.2', 224 => '10.5', 225 => '3.4', 226 => '6.1', 228 => '4.2' },
	'gripbatteryadload' => { 258 => 0x5 },
	'gripbatteryadnoload' => { 258 => 0x4 },
	'gripbatterystate' => { 258 => '1.2' },
	'halftonehints' => { 93 => 0x141 },
	'hasalternative' => { 360 => 'hasAlternative' },
	'hascorrection' => { 360 => 'hasCorrection' },
	'hascrop' => { 347 => 'HasCrop' },
	'hasextendedxmp' => { 371 => 'HasExtendedXMP' },
	'haspreviousversion' => { 360 => 'hasPreviousVersion' },
	'hassettings' => { 347 => 'HasSettings' },
	'hastranslation' => { 360 => 'hasTranslation' },
	'hdr' => { 172 => 0x4, 319 => 0x200a },
	'hdrinfoversion' => { 172 => 0x0 },
	'hdrlevel' => { 172 => 0x5, 310 => 0x2e, 322 => 0x17 },
	'hdrlevel2' => { 172 => 0x7 },
	'hdrsetting' => { 310 => 0x2d, 322 => 0x16 },
	'hdrsmoothing' => { 172 => 0x6 },
	'headline' => { 101 => 0x69, 358 => 'Headline' },
	'hierarchicalkeywords' => { 138 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 138 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 138 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 138 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 138 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 138 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 138 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 339 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 92 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisonoisereduction' => { 13 => 0xbc, 14 => 0xbd, 17 => 0xbd, 23 => 0xc9, 66 => 0x202, 98 => 0x100e, 179 => 0xb1, 279 => 0x71, 308 => 0x2c, 309 => 0x26, 310 => 0x26, 319 => 0x2009, 322 => 0x12 },
	'highisonoisereduction2' => { 319 => 0xb050 },
	'highlight' => { 304 => 0xf },
	'highlightcolordistortreduct' => { 333 => 0x8026 },
	'highlightprotection' => { 211 => 0x6 },
	'highlightrecovery' => { 347 => 'HighlightRecovery' },
	'highlights' => { 341 => 'Highlights' },
	'highlights2012' => { 347 => 'Highlights2012' },
	'highlighttonepriority' => { 10 => 0x7, 13 => 0x7, 14 => 0x7, 15 => 0x7, 17 => 0x7, 19 => 0x7, 23 => 0x7, 66 => 0x203 },
	'highlowkeyadj' => { 279 => 0x6c },
	'highspeedsync' => { 148 => 0x5 },
	'histogramxml' => { 212 => 0x83a1a25 },
	'history' => { 358 => 'History', 370 => 'History' },
	'historyaction' => { 370 => [\'History','HistoryAction'] },
	'historychanged' => { 370 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 370 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 370 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 370 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 370 => [\'History','HistoryWhen'] },
	'hometowncity' => { 89 => 0x3006, 279 => 0x23, 283 => 0x2 },
	'hometowncitycode' => { 284 => 0x1000 },
	'hometowndst' => { 279 => 0x25, 283 => '0.2' },
	'hostcomputer' => { 93 => 0x13c },
	'hue' => { 153 => 0x3b, 279 => 0x67 },
	'hueadj' => { 215 => 0x2f, 333 => 0x8019 },
	'hueadjustment' => { 146 => 0x4a, 147 => 0x40, 179 => 0x92, 181 => 0x36 },
	'hueadjustmentaqua' => { 347 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 347 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 347 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 347 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 347 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 347 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 347 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 347 => 'HueAdjustmentYellow' },
	'huesetting' => { 237 => 0x1011 },
	'icc_profile' => { 94 => 'ICC_Profile' },
	'iccprofilename' => { 358 => 'ICCProfile' },
	'idccreativestyle' => { 333 => 0x8000 },
	'idcpreviewlength' => { 333 => 0x202 },
	'idcpreviewstart' => { 333 => 0x201 },
	'identification' => { 92 => 'Identification' },
	'identificationid' => { 92 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 92 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 92 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 92 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identifiedby' => { 92 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 348 => 'identifier', 367 => 'Identifier' },
	'illumination' => { 226 => '0.5' },
	'imageadjustment' => { 179 => 0x80, 202 => 0x5 },
	'imagealterationconstraints' => { 359 => 'ImageAlterationConstraints' },
	'imagearea' => { 189 => 0x10, 192 => 0x10 },
	'imageareaoffset' => { 279 => 0x38 },
	'imageauthentication' => { 179 => 0x20 },
	'imageboundary' => { 179 => 0x16 },
	'imagecount' => { 179 => 0xa5, 320 => 0x11b, 325 => 0x32 },
	'imagecreator' => { 359 => 'ImageCreator' },
	'imagecreatorid' => { 359 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 359 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 359 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 179 => 0xa2 },
	'imagedescription' => { 93 => 0x10e, 365 => 'ImageDescription' },
	'imageduplicationconstraints' => { 359 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 212 => 0xfe443a45 },
	'imageeditcount' => { 279 => 0x41 },
	'imageediting' => { 279 => 0x32 },
	'imagefileconstraints' => { 359 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 359 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 359 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 93 => 0x101, 152 => 0xc, 365 => 'ImageLength' },
	'imagehistory' => { 93 => 0x9213 },
	'imageidnumber' => { 244 => 0x340 },
	'imagenumber' => { 93 => 0x9211, 123 => 'ImageNumber', 146 => 0xae, 147 => 0x5e, 308 => 0x9b, 310 => [0x400,0x114,0x314], 344 => 'ImageNumber' },
	'imagenumber2' => { 147 => 0x62 },
	'imageoptimization' => { 179 => 0xa9 },
	'imageorientation' => { 101 => 0x83 },
	'imageprocessing' => { 179 => 0x1a },
	'imageprocessingversion' => { 233 => 0x0 },
	'imagequality' => { 123 => 'ImageQuality', 191 => '723.2', 192 => '732.2', 199 => '708.1', 248 => 0x1 },
	'imagequality2' => { 229 => 0x603 },
	'imageref' => { 354 => 'ImageRef' },
	'imagereview' => { 220 => '0.4', 226 => '0.4' },
	'imagereviewtime' => { 220 => '2.1', 221 => '19.1', 222 => '20.1', 223 => '20.1', 224 => '9.2', 225 => '20.1', 228 => '21.2' },
	'imagesize' => { 129 => 'ImageSize' },
	'imagesizerestriction' => { 362 => 'imageSizeRestriction' },
	'imagesourcedata' => { 93 => 0x935c },
	'imagestabilization' => { 27 => 0x22, 89 => 0x3020, 123 => 'ImageStabilization', 146 => 0xbd, 147 => 0x71, 148 => 0x57, 149 => 0x0, 150 => [0x18,0x107,0x113], 151 => 0x49c2, 179 => 0xac, 229 => 0x604, 232 => 0x1600, 248 => 0x1a, 313 => 0x12, 314 => 0x11, 319 => 0xb026 },
	'imagestabilization2' => { 312 => 0xa },
	'imagestabilizationsetting' => { 151 => 0x14, 308 => 0x3d, 309 => 0x3d, 318 => 0x14 },
	'imagestyle' => { 308 => 0x2d, 309 => 0x27 },
	'imagesupplier' => { 359 => 'ImageSupplier' },
	'imagesupplierid' => { 359 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 359 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 359 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 95 => 0x1 },
	'imagetemperaturemin' => { 95 => 0x2 },
	'imagetone' => { 279 => 0x4f },
	'imagetype' => { 101 => 0x82, 359 => 'ImageType' },
	'imageuniqueid' => { 49 => 0x28, 93 => 0xa420, 351 => 'ImageUniqueID' },
	'imagewidth' => { 93 => 0x100, 152 => 0xe, 365 => 'ImageWidth' },
	'incrementaltemperature' => { 347 => 'IncrementalTemperature' },
	'incrementaltint' => { 347 => 'IncrementalTint' },
	'industry' => { 360 => 'industry', 361 => 'industry' },
	'infobuttonwhenshooting' => { 66 => 0x409 },
	'infraredilluminator' => { 292 => 0x28 },
	'ingredients' => { 370 => 'Ingredients' },
	'ingredientsalternatepaths' => { 370 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 370 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 370 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 370 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 370 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 370 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 370 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 370 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 370 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 370 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 370 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 370 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 370 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 370 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 370 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 370 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 370 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 337 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 337 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 337 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 337 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 219 => '4.4' },
	'initialzoomsetting' => { 219 => '9.3', 224 => '27.3' },
	'inkset' => { 93 => 0x14c },
	'instanceid' => { 370 => 'InstanceID' },
	'instantplaybacksetup' => { 148 => 0x3e },
	'instantplaybacktime' => { 148 => 0x3d },
	'instructions' => { 358 => 'Instructions' },
	'instrument' => { 369 => 'instrument' },
	'intellectualgenre' => { 355 => 'IntellectualGenre' },
	'intelligentauto' => { 319 => 0xb052 },
	'intelligentcontrast' => { 39 => 0x4 },
	'intelligentd-range' => { 248 => 0x79 },
	'intelligentexposure' => { 248 => 0x5d },
	'intelligentresolution' => { 248 => 0x70 },
	'interchangecolorspace' => { 103 => 0x40 },
	'internalflash' => { 145 => 0x2b, 219 => '23.1', 220 => '8.1', 221 => '22.1', 223 => '23.1', 226 => '8.1', 228 => '24.1', 232 => 0x1208 },
	'internalflashae1' => { 234 => 0x1021 },
	'internalflashae1_0' => { 234 => 0x101d },
	'internalflashae2' => { 234 => 0x1022 },
	'internalflashae2_0' => { 234 => 0x101e },
	'internalflashmode' => { 267 => 0x1 },
	'internalflashstrength' => { 267 => 0x3 },
	'internalflashtable' => { 234 => 0x1024 },
	'internalserialnumber' => { 49 => 0x96, 59 => 0x9, 98 => 0x10, 151 => 0x49dc, 230 => 0x102, 248 => 0x25, 259 => 0x4, 296 => 0x5 },
	'interopindex' => { 93 => 0x1 },
	'interopversion' => { 93 => 0x2 },
	'intervallength' => { 145 => 0x10 },
	'intervalmode' => { 145 => 0x26 },
	'intervalnumber' => { 145 => 0x11 },
	'introtime' => { 369 => 'introTime' },
	'introtimescale' => { 369 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 369 => [\'introTime','introTimeValue'] },
	'iptc' => { 94 => 'IPTC' },
	'iptc-naa' => { 93 => 0x83bb, 252 => 0x83bb },
	'iptcbitspersample' => { 103 => 0x56 },
	'iptcdigest' => { 289 => 0x425 },
	'iptcimageheight' => { 103 => 0x1e },
	'iptcimagerotation' => { 103 => 0x66 },
	'iptcimagewidth' => { 103 => 0x14 },
	'iptclastedited' => { 356 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 103 => 0xa },
	'iptcpixelheight' => { 103 => 0x32 },
	'iptcpixelwidth' => { 103 => 0x28 },
	'isbn' => { 360 => 'isbn' },
	'iscorrectionof' => { 360 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 85 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x6, 7 => 0x75, 8 => 0x6, 9 => 0x79, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x0, 25 => 0x1, 88 => 0x14, 89 => [0x3014,0x14], 93 => 0x8827, 106 => 0xfd06, 107 => 0x1784, 109 => 0x60, 111 => [0xfa2e,0xfa46], 112 => [0x27,0x28], 113 => 0xf105, 116 => 0x14, 118 => 0x4e, 121 => 0x34, 123 => 'ISO', 145 => 0x8, 151 => 0x49ba, 173 => 0x0, 179 => 0x2, 252 => 0x17, 279 => [0x8b,0x14], 284 => 0x14, 301 => 0xa014, 351 => 'ISOSpeedRatings' },
	'iso2' => { 173 => 0x6, 186 => 0x265, 187 => 0x25c, 188 => 0x265, 189 => 0x221, 190 => 0x25d, 191 => 0x256, 192 => 0x25d, 194 => 0x2b5, 197 => 0x265, 201 => 0x2b5 },
	'isoauto' => { 260 => '14.4' },
	'isoautoparameters' => { 279 => 0x7a },
	'isodisplay' => { 221 => '2.3', 222 => '3.3', 223 => '3.3', 225 => '3.3', 228 => '4.3' },
	'isoexpansion' => { 66 => 0x103, 67 => 0x7, 68 => 0x8, 71 => 0x8, 173 => 0x4 },
	'isoexpansion2' => { 173 => 0xa },
	'isofloor' => { 260 => 0x6 },
	'isoselection' => { 179 => 0xf },
	'isosensitivitystep' => { 225 => '6.2' },
	'isosetting' => { 109 => 0x5e, 123 => 'ISOSetting', 145 => 0x24, 146 => 0x26, 147 => 0x1c, 148 => 0x13, 153 => 0x6, 179 => 0x13, 260 => '17.3', 295 => 0x27, 308 => 0x16, 309 => 0x14, 310 => 0x2 },
	'isospeed' => { 93 => 0x8833 },
	'isospeedexpansion' => { 65 => 0x3 },
	'isospeedincrements' => { 66 => 0x102 },
	'isospeedlatitudeyyy' => { 93 => 0x8834 },
	'isospeedlatitudezzz' => { 93 => 0x8835 },
	'isospeedrange' => { 66 => 0x103 },
	'isostepsize' => { 219 => '6.1', 224 => '4.1' },
	'isovalue' => { 234 => 0x1001 },
	'issn' => { 360 => 'issn' },
	'issueidentifier' => { 360 => 'issueIdentifier' },
	'issuename' => { 360 => 'issueName' },
	'istranslationof' => { 360 => 'isTranslationOf' },
	'jobid' => { 101 => 0xb8 },
	'jobname' => { 352 => 'JobName' },
	'jobref' => { 368 => 'JobRef' },
	'jobrefid' => { 368 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 368 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 368 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 352 => 'JobStatus' },
	'jpegquality' => { 7 => 0x66, 250 => 0x3034, 319 => 0xb047 },
	'jpegsize' => { 250 => 0x303a },
	'jpgfromraw' => { 79 => 0x2007, 90 => 'JpgFromRaw', 252 => 0x2e },
	'jpgfromrawlength' => { 93 => [0x117,0x202] },
	'jpgfromrawstart' => { 93 => [0x111,0x201] },
	'jpgrecordedpixels' => { 260 => '14.1' },
	'jurisdiction' => { 345 => 'jurisdiction' },
	'kelvinwb_01' => { 268 => 0x5 },
	'kelvinwb_02' => { 268 => 0x9 },
	'kelvinwb_03' => { 268 => 0xd },
	'kelvinwb_04' => { 268 => 0x11 },
	'kelvinwb_05' => { 268 => 0x15 },
	'kelvinwb_06' => { 268 => 0x19 },
	'kelvinwb_07' => { 268 => 0x1d },
	'kelvinwb_08' => { 268 => 0x21 },
	'kelvinwb_09' => { 268 => 0x25 },
	'kelvinwb_10' => { 268 => 0x29 },
	'kelvinwb_11' => { 268 => 0x2d },
	'kelvinwb_12' => { 268 => 0x31 },
	'kelvinwb_13' => { 268 => 0x35 },
	'kelvinwb_14' => { 268 => 0x39 },
	'kelvinwb_15' => { 268 => 0x3d },
	'kelvinwb_16' => { 268 => 0x41 },
	'kelvinwb_daylight' => { 268 => 0x1 },
	'key' => { 369 => 'key' },
	'keyword' => { 360 => 'keyword' },
	'keywordinfo' => { 138 => 'Keywords' },
	'keywords' => { 101 => 0x19, 124 => 'Keywords', 238 => 'Keywords', 291 => 'Keywords', 342 => 'keywords', 357 => 'Keywords', 367 => 'Keywords' },
	'killdate' => { 360 => 'killDate' },
	'kodakimageheight' => { 106 => 0xf908, 109 => 0xe, 111 => [0xfa1e,0xfa52], 117 => 0x70 },
	'kodakimagewidth' => { 106 => 0xf907, 109 => 0xc, 111 => [0xfa1d,0xfa51], 117 => 0x6c },
	'kodakinfotype' => { 106 => 0xfa00 },
	'kodakmaker' => { 117 => 0x8 },
	'kodakmodel' => { 109 => 0x0, 117 => 0x28 },
	'label' => { 240 => 'Label', 367 => 'Label' },
	'labelname1' => { 354 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 354 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 248 => 0x6f },
	'landscapeoutputhighlightpoint' => { 85 => 0x26 },
	'landscapeoutputshadowpoint' => { 85 => 0x27 },
	'landscaperawcolortone' => { 85 => 0x1f },
	'landscaperawcontrast' => { 85 => 0x21 },
	'landscaperawhighlight' => { 85 => 0x77 },
	'landscaperawhighlightpoint' => { 85 => 0x24 },
	'landscaperawlinear' => { 85 => 0x22 },
	'landscaperawsaturation' => { 85 => 0x20 },
	'landscaperawshadow' => { 85 => 0x80 },
	'landscaperawshadowpoint' => { 85 => 0x25 },
	'landscaperawsharpness' => { 85 => 0x23 },
	'landscapeunsharpmaskfineness' => { 85 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 85 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 85 => 0xa2 },
	'language' => { 348 => 'language' },
	'languageidentifier' => { 101 => 0x87 },
	'largestvalidinteriorrectheight' => { 337 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 337 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 337 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 337 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 145 => 0x1b },
	'lastkeywordiptc' => { 143 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 143 => 'LastKeywordXMP' },
	'lastphotodate' => { 337 => 'LastPhotoDate' },
	'lasturl' => { 370 => 'LastURL' },
	'lateralchromaticaberration' => { 319 => 0x2012 },
	'latestageorhigheststage' => { 92 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 92 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 92 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latestperiodorhighestsystem' => { 92 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 270 => 0x2 },
	'lc10' => { 270 => 0xb },
	'lc11' => { 270 => 0xc },
	'lc12' => { 270 => 0xd },
	'lc14' => { 270 => 0xf },
	'lc15' => { 270 => 0x10 },
	'lc2' => { 270 => 0x3 },
	'lc3' => { 270 => 0x4 },
	'lc4' => { 270 => 0x5 },
	'lc5' => { 270 => 0x6 },
	'lc6' => { 270 => 0x7 },
	'lc7' => { 270 => 0x8 },
	'lcddisplayatpoweron' => { 66 => 0x811, 70 => 0xa },
	'lcddisplayreturntoshoot' => { 71 => 0x12 },
	'lcdillumination' => { 219 => '17.5', 224 => '10.3', 225 => '4.2', 228 => '5.4' },
	'lcdilluminationduringbulb' => { 66 => 0x408 },
	'lcdpanels' => { 65 => 0x8 },
	'lcheditor' => { 212 => 0x8ae85e },
	'legacyiptcdigest' => { 358 => 'LegacyIPTCDigest' },
	'legalcode' => { 345 => 'legalcode' },
	'lens' => { 93 => 0xfdea, 179 => 0x84, 344 => 'Lens' },
	'lensafstopbutton' => { 64 => 0x11, 65 => 0x13, 66 => 0x506, 67 => 0x10, 68 => 0x12, 71 => 0x13, 72 => 0x9 },
	'lensaperturerange' => { 304 => [0x30,0x48] },
	'lensdistortionparams' => { 234 => 0x206 },
	'lensdrivenoaf' => { 66 => 0x505 },
	'lensfirmware' => { 297 => 0x20, 301 => 0xa004 },
	'lensfirmwareversion' => { 230 => 0x204 },
	'lensfocalrange' => { 304 => [0xa,0x2a] },
	'lensformat' => { 325 => 0x106, 330 => 0x603 },
	'lensfstops' => { 174 => 0x7, 175 => 0xc, 176 => 0xd, 179 => 0x8b, 270 => '0.3' },
	'lensid' => { 344 => 'LensID' },
	'lensidnumber' => { 174 => 0x6, 175 => 0xb, 176 => 0xc },
	'lensinfo' => { 93 => 0xa432, 276 => 0x2a, 344 => 'LensInfo' },
	'lenskind' => { 270 => 0x1 },
	'lensmake' => { 93 => 0xa433, 130 => 'Make' },
	'lensmanualdistortionamount' => { 347 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 143 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 304 => 0x2b },
	'lensmodel' => { 4 => 0x937, 11 => 0x92b, 12 => 0x933, 49 => 0x95, 93 => 0xa434, 130 => 'Model', 143 => 'LensModel', 177 => 0x18a, 230 => 0x203, 276 => 0xc },
	'lensmount' => { 325 => 0x105, 330 => 0x604 },
	'lensprofilechromaticaberrationscale' => { 347 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 347 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 347 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 347 => 'LensProfileEnable' },
	'lensprofilefilename' => { 347 => 'LensProfileFilename' },
	'lensprofilename' => { 347 => 'LensProfileName' },
	'lensprofilesetup' => { 347 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 347 => 'LensProfileVignettingScale' },
	'lensproperties' => { 230 => 0x20b },
	'lensserialnumber' => { 47 => 0x0, 93 => 0xa435, 130 => 'SerialNumber', 230 => 0x202, 248 => 0x52, 297 => 0x30 },
	'lensshutterlock' => { 148 => 0x4a },
	'lensspec' => { 306 => 0x0, 307 => 0x0, 319 => 0xb02a },
	'lenstemperature' => { 234 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0x1a7, 7 => 0xc, 8 => 0x111, 9 => 0xc, 10 => 0x14f, 11 => 0xd6, 12 => 0xde, 13 => 0xf6, 14 => 0xea, 15 => 0xff, 16 => [0xc,0x97], 17 => 0xe6, 18 => 0x153, 19 => 0xea, 20 => 0xe8, 21 => 0x127, 22 => 0x161, 23 => 0x112, 27 => 0x16, 150 => 0x10c, 151 => 0x49bd, 179 => 0x83, 230 => 0x201, 241 => 0x16, 244 => 0x310, 247 => 0x303, 248 => 0x51, 250 => 0x3405, 271 => 0x0, 272 => 0x0, 273 => 0x1, 274 => 0x1, 275 => 0x1, 277 => 0x0, 301 => 0xa003, 304 => 0x27, 319 => 0xb027, 325 => 0x109, 330 => 0x608 },
	'lenstype2' => { 310 => 0x3f7, 325 => 0x107, 330 => 0x605 },
	'levelgaugepitch' => { 229 => 0x904 },
	'levelgaugeroll' => { 229 => 0x903 },
	'levelorientation' => { 278 => 0x0 },
	'license' => { 345 => 'license' },
	'licensee' => { 359 => 'Licensee' },
	'licenseeid' => { 359 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 359 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 359 => 'LicenseeImageNotes' },
	'licenseename' => { 359 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 359 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 359 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 359 => 'LicenseeTransactionID' },
	'licenseid' => { 359 => 'LicenseID' },
	'licensestartdate' => { 359 => 'LicenseStartDate' },
	'licensetransactiondate' => { 359 => 'LicenseTransactionDate' },
	'licensetype' => { 349 => 'licensetype' },
	'licensor' => { 359 => 'Licensor' },
	'licensorcity' => { 359 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 359 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 359 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 359 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 359 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 359 => 'LicensorImageID' },
	'licensorname' => { 359 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 359 => 'LicensorNotes' },
	'licensorpostalcode' => { 359 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 359 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 359 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 359 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 359 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 359 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 359 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 359 => 'LicensorTransactionID' },
	'licensorurl' => { 359 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 234 => 0x1009 },
	'lightingmode' => { 89 => 0x302a },
	'lightreading' => { 279 => 0x15 },
	'lightsource' => { 93 => 0x9208, 179 => 0x90, 237 => 0x1000, 351 => 'LightSource' },
	'lightsourcespecial' => { 303 => 0x21d },
	'lightswitch' => { 228 => '0.1' },
	'lightvaluecenter' => { 234 => 0x103d },
	'lightvalueperiphery' => { 234 => 0x103e },
	'linearizationtable' => { 93 => 0xc618 },
	'linearresponselimit' => { 93 => 0xc62e },
	'linkaetoafpoint' => { 260 => '14.2' },
	'lithostratigraphicterms' => { 92 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 221 => '32.1', 228 => '34.1' },
	'liveviewafareamode' => { 225 => '34.1' },
	'liveviewafmethod' => { 322 => 0x20 },
	'liveviewafmode' => { 225 => '34.2' },
	'liveviewafsetting' => { 310 => 0x36 },
	'liveviewexposuresimulation' => { 66 => 0x810 },
	'liveviewfocusmode' => { 310 => 0x8b },
	'liveviewmetering' => { 310 => 0x84 },
	'liveviewmonitorofftime' => { 222 => '20.2', 223 => '20.2', 225 => '20.2' },
	'liveviewshooting' => { 44 => 0x13 },
	'localcaption' => { 101 => 0x79 },
	'localizedcameramodel' => { 93 => 0xc615 },
	'locallocationname' => { 301 => 0x30 },
	'location' => { 178 => 0x9, 248 => 0x67, 340 => 'Location', 355 => 'Location', 360 => 'location' },
	'locationareacode' => { 346 => 'lac' },
	'locationcreated' => { 356 => 'LocationCreated' },
	'locationcreatedcity' => { 356 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 356 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 356 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 356 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 356 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 356 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 178 => 0x0 },
	'locationname' => { 301 => 0x31 },
	'locationshown' => { 356 => 'LocationShown' },
	'locationshowncity' => { 356 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 356 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 356 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 356 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 356 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 356 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 66 => 0x709 },
	'logcomment' => { 369 => 'logComment' },
	'longexposurenoisereduction' => { 66 => 0x201, 67 => 0x1, 68 => 0x2, 69 => 0x1, 70 => 0x1, 71 => 0x2, 72 => 0x1, 308 => 0x2b, 309 => 0x25, 310 => 0x25, 319 => [0xb04e,0x2008], 322 => 0x11 },
	'longexposurenoisereduction2' => { 44 => 0x8 },
	'loop' => { 369 => 'loop' },
	'lowestbiostratigraphiczone' => { 92 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 347 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 347 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 347 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 347 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 347 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 347 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 347 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 347 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 84 => 0x150 },
	'luminancecurvepoints' => { 84 => 0x126 },
	'luminancenoisereduction' => { 85 => 0x5f, 304 => 0x1b },
	'luminancenoisereductioncontrast' => { 347 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 347 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 85 => 0x6d },
	'luminancesmoothing' => { 347 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 66 => 0x40b },
	'm16cversion' => { 244 => 0x333 },
	'macro' => { 98 => 0x1020, 99 => 0x202, 234 => 0x202, 295 => 0x21, 303 => 0x202, 319 => 0xb040 },
	'macroled' => { 232 => 0x120a },
	'macromagnification' => { 4 => 0x1b, 8 => 0x1b, 11 => 0x1b, 12 => 0x1b, 16 => 0x1b, 17 => 0x1b, 44 => 0x10 },
	'macromode' => { 27 => 0x1, 145 => 0xb, 229 => 0x300, 248 => 0x1c },
	'magicfilter' => { 229 => 0x52c },
	'magnifiedview' => { 68 => 0x11, 70 => 0x9 },
	'maindialexposurecomp' => { 226 => '0.6' },
	'make' => { 80 => 0x0, 93 => 0x10f, 123 => 'Make', 240 => 'Make', 252 => 0x10f, 365 => 'Make' },
	'makernote' => { 351 => 'MakerNote' },
	'makernotecanon' => { 91 => 'MakN', 93 => 0x927c },
	'makernotecasio' => { 91 => 'MakN', 93 => 0x927c },
	'makernotecasio2' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteflir' => { 91 => 'MakN', 93 => 0x927c },
	'makernotefujifilm' => { 91 => 'MakN', 93 => 0x927c },
	'makernotege' => { 91 => 'MakN', 93 => 0x927c },
	'makernotege2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotehasselblad' => { 91 => 'MakN', 93 => 0x927c },
	'makernotehp' => { 91 => 'MakN', 93 => 0x927c },
	'makernotehp2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotehp4' => { 91 => 'MakN', 93 => 0x927c },
	'makernotehp6' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteisl' => { 91 => 'MakN', 93 => 0x927c },
	'makernotejvc' => { 91 => 'MakN', 93 => 0x927c },
	'makernotejvctext' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak10' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak1a' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak1b' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak3' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak4' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak5' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak6a' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak6b' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak7' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak8a' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak8b' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodak9' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekodakunknown' => { 91 => 'MakN', 93 => 0x927c },
	'makernotekyocera' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteleica' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteleica2' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteleica3' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteleica4' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteleica5' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteleica6' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteminolta' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteminolta2' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteminolta3' => { 91 => 'MakN', 93 => 0x927c },
	'makernotenikon' => { 91 => 'MakN', 93 => 0x927c },
	'makernotenikon2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotenikon3' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteoffset' => { 303 => 0xff },
	'makernoteolympus' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteolympus2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepanasonic' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepanasonic2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepentax' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepentax2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepentax3' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepentax4' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepentax5' => { 91 => 'MakN', 93 => 0x927c },
	'makernotepentax6' => { 91 => 'MakN', 93 => 0x927c },
	'makernotephaseone' => { 91 => 'MakN', 93 => 0x927c },
	'makernotereconyx' => { 91 => 'MakN', 93 => 0x927c },
	'makernotericoh' => { 91 => 'MakN', 93 => 0x927c },
	'makernotericohtext' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesafety' => { 93 => 0xc635 },
	'makernotesamsung1a' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesamsung1b' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesamsung2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesanyo' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesanyoc4' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesanyopatch' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesigma' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesony' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesony2' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesony3' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesony4' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesonyericsson' => { 91 => 'MakN', 93 => 0x927c },
	'makernotesonysrf' => { 91 => 'MakN', 93 => 0x927c },
	'makernotetype' => { 296 => 0x1 },
	'makernoteunknown' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteunknownbinary' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteunknowntext' => { 91 => 'MakN', 93 => 0x927c },
	'makernoteversion' => { 150 => 0x0, 179 => 0x1, 234 => 0x0, 248 => 0x8000, 300 => 0x0, 301 => 0x1, 304 => [0x1d,0x1f], 311 => 0x2000 },
	'managedfrom' => { 370 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 370 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 370 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 370 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 370 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 370 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 370 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 370 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 370 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 370 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 370 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 370 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 370 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 370 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 370 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 370 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 370 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 370 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 370 => 'Manager' },
	'managervariant' => { 370 => 'ManagerVariant' },
	'manageto' => { 370 => 'ManageTo' },
	'manageui' => { 370 => 'ManageUI' },
	'manifest' => { 370 => 'Manifest' },
	'manifestlinkform' => { 370 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 370 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 370 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 370 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 370 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 370 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 370 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 370 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 370 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 370 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 370 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 370 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 370 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 370 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 370 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 370 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 370 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 370 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 370 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 370 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 370 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 370 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 229 => 0x900, 248 => 0x86 },
	'manometerreading' => { 229 => 0x901 },
	'manualafpointselectpattern' => { 66 => 0x513 },
	'manualflash' => { 232 => 0x1209 },
	'manualflashoutput' => { 27 => 0x29, 220 => '8.2', 221 => '22.2', 222 => '23.1', 223 => '23.2', 224 => '16.2', 225 => '23.2', 226 => '8.2', 227 => '23.2', 228 => '24.2' },
	'manualflashstrength' => { 229 => 0x406 },
	'manualfocusdistance' => { 179 => 0x85, 234 => 0x100c, 303 => 0x223 },
	'manualtv' => { 65 => 0x5, 66 => 0x705 },
	'manufacturedate' => { 259 => 0x1 },
	'manufacturedate1' => { 298 => 0x4 },
	'manufacturedate2' => { 298 => 0x5 },
	'marked' => { 357 => 'Marked', 373 => 'Marked' },
	'markers' => { 369 => 'markers' },
	'markerscomment' => { 369 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 369 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 369 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 369 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 369 => [\'markers','markersCuePointType'] },
	'markersduration' => { 369 => [\'markers','markersDuration'] },
	'markerslocation' => { 369 => [\'markers','markersLocation'] },
	'markersname' => { 369 => [\'markers','markersName'] },
	'markersprobability' => { 369 => [\'markers','markersProbability'] },
	'markersspeaker' => { 369 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 369 => [\'markers','markersStartTime'] },
	'markerstarget' => { 369 => [\'markers','markersTarget'] },
	'markerstype' => { 369 => [\'markers','markersType'] },
	'maskedareas' => { 93 => 0xc68e },
	'masterdocumentid' => { 101 => 0xb9 },
	'mastergain' => { 184 => 0x50 },
	'maxaperture' => { 27 => 0x1a, 113 => 0x6103, 130 => 'MaxAperture', 145 => 0x17, 151 => 0x49c5, 230 => 0x20a, 270 => '14.1', 325 => 0x0 },
	'maxapertureatmaxfocal' => { 98 => 0x1407, 130 => 'MaxApertureAtMaxFocal', 174 => 0xb, 175 => 0x10, 176 => 0x11, 230 => 0x206 },
	'maxapertureatminfocal' => { 98 => 0x1406, 174 => 0xa, 175 => 0xf, 176 => 0x10, 230 => 0x205 },
	'maxaperturevalue' => { 93 => 0x9205, 351 => 'MaxApertureValue' },
	'maxavailheight' => { 356 => 'MaxAvailHeight' },
	'maxavailwidth' => { 356 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 219 => 0xb, 224 => 0xc, 225 => 0xb },
	'maxfaces' => { 233 => 0x1202 },
	'maxfocallength' => { 4 => 0xe6, 5 => 0x10, 6 => 0x1ab, 7 => 0x13, 8 => 0x115, 9 => 0x13, 10 => 0x153, 11 => 0xda, 13 => 0xfa, 14 => 0xee, 15 => 0x103, 16 => 0x95, 17 => 0xea, 18 => 0x157, 19 => 0xee, 20 => 0xec, 21 => 0x12b, 22 => 0x165, 23 => 0x116, 27 => 0x17, 98 => 0x1405, 130 => 'MaxFocalLength', 174 => 0x9, 175 => 0xe, 176 => 0xf, 230 => 0x208 },
	'maximumdensityrange' => { 103 => 0x8c },
	'maxpagesize' => { 374 => 'MaxPageSize' },
	'maxpagesizeh' => { 374 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 374 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 374 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 93 => 0x119 },
	'maxstorage' => { 364 => 'maxstorage' },
	'mb-d10batteries' => { 219 => '12.6' },
	'mb-d10batterytype' => { 224 => '13.3' },
	'mb-d11batterytype' => { 225 => '2.3' },
	'mb-d80batteries' => { 226 => '6.5' },
	'mb-d80batterytype' => { 228 => '3.2' },
	'mcuversion' => { 174 => 0xc, 175 => 0x11, 176 => 0x12 },
	'md5digest' => { 131 => 'zmd5' },
	'measuredev' => { 23 => 0x9, 60 => 0x3, 79 => 0x1814, 123 => 'MeasuredEV' },
	'measuredev2' => { 10 => 0x8, 23 => 0x8, 60 => 0x17 },
	'measuredev3' => { 10 => 0x9 },
	'measuredlv' => { 151 => 0x690, 244 => 0x312, 250 => 0x3407 },
	'measuredrggb' => { 50 => 0x1 },
	'measuredrggbdata' => { 33 => 0x287 },
	'measurementaccuracy' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 92 => 'MeasurementOrFact' },
	'measurementremarks' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 92 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 359 => 'MediaConstraints' },
	'mediasummarycode' => { 359 => 'MediaSummaryCode' },
	'memorycardconfiguration' => { 314 => 0x16 },
	'menubuttondisplayposition' => { 64 => 0xb, 67 => 0xa, 68 => 0xb, 71 => 0xb },
	'menubuttonreturn' => { 72 => 0xb },
	'menumonitorofftime' => { 224 => '8.2', 225 => '21.1', 228 => '22.1' },
	'metadatadate' => { 367 => 'MetadataDate' },
	'metadatamoddate' => { 369 => 'metadataModDate' },
	'metering' => { 220 => '6.1' },
	'meteringmode' => { 27 => 0x11, 93 => 0x9207, 109 => 0x1c, 145 => 0x7, 146 => 0x25, 148 => 0x12, 229 => 0x202, 279 => 0x17, 304 => 0x9, 308 => 0x15, 309 => 0x13, 310 => 0x7, 322 => 0x3, 351 => 'MeteringMode' },
	'meteringmode2' => { 260 => '2.1' },
	'meteringmode3' => { 260 => '16.1' },
	'meteringoffscaleindicator' => { 148 => 0x53 },
	'meteringtime' => { 219 => '22.2', 220 => '3.2', 221 => '17.1', 222 => '18.1', 224 => '7.3', 225 => '18.1', 226 => '3.2', 228 => '19.1' },
	'mieversion' => { 131 => '0Vers' },
	'minaperture' => { 27 => 0x1b, 130 => 'MinAperture', 270 => '0.2', 325 => 0x1 },
	'minfocallength' => { 4 => 0xe4, 5 => 0xe, 6 => 0x1a9, 7 => 0x11, 8 => 0x113, 9 => 0x11, 10 => 0x151, 11 => 0xd8, 13 => 0xf8, 14 => 0xec, 15 => 0x101, 16 => 0x93, 17 => 0xe8, 18 => 0x155, 19 => 0xec, 20 => 0xea, 21 => 0x129, 22 => 0x163, 23 => 0x114, 27 => 0x18, 98 => 0x1404, 130 => 'MinFocalLength', 174 => 0x8, 175 => 0xd, 176 => 0xe, 230 => 0x207 },
	'minoltadate' => { 145 => 0x15 },
	'minoltaimagesize' => { 145 => 0x4, 146 => 0xc, 147 => 0x2, 150 => 0x103 },
	'minoltamodelid' => { 145 => 0x25 },
	'minoltaquality' => { 145 => 0x5, 146 => 0xd, 147 => 0x3, 150 => [0x102,0x103] },
	'minoltatime' => { 145 => 0x16 },
	'minormodelagedisclosure' => { 359 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 93 => 0x118 },
	'mirrorlockup' => { 64 => 0xc, 65 => 0xc, 66 => 0x60f, 67 => 0xb, 68 => 0xc, 69 => 0x6, 70 => 0x6, 71 => 0xc, 72 => 0x3 },
	'mobilecountrycode' => { 346 => 'mcc' },
	'mobilenetworkcode' => { 346 => 'mnc' },
	'moddate' => { 240 => 'modify-date', 357 => 'ModDate' },
	'modedialposition' => { 314 => 0x14 },
	'model' => { 80 => 0x6, 93 => 0x110, 123 => 'Model', 240 => 'Model', 252 => 0x110, 365 => 'Model' },
	'modelage' => { 356 => 'ModelAge' },
	'modelingflash' => { 219 => '21.4', 224 => '26.4', 225 => '30.2', 226 => '7.4', 227 => '30.1', 228 => '31.3' },
	'modelreleaseid' => { 359 => 'ModelReleaseID' },
	'modelreleasestatus' => { 359 => 'ModelReleaseStatus' },
	'modificationdate' => { 360 => 'modificationDate' },
	'modifiedcolortemp' => { 51 => 0x9 },
	'modifieddigitalgain' => { 51 => 0xb },
	'modifiedparamflag' => { 45 => 0x1 },
	'modifiedpicturestyle' => { 51 => 0xa },
	'modifiedsaturation' => { 229 => 0x504 },
	'modifiedsensorbluelevel' => { 51 => 0x5 },
	'modifiedsensorredlevel' => { 51 => 0x4 },
	'modifiedsharpness' => { 51 => 0x2 },
	'modifiedsharpnessfreq' => { 51 => 0x3 },
	'modifiedtonecurve' => { 51 => 0x1 },
	'modifiedwhitebalance' => { 51 => 0x8 },
	'modifiedwhitebalanceblue' => { 51 => 0x7 },
	'modifiedwhitebalancered' => { 51 => 0x6 },
	'modifydate' => { 93 => 0x132, 124 => 'ModifyDate', 238 => 'ModDate', 239 => 'tIME', 291 => 'ModDate', 367 => 'ModifyDate' },
	'moirefilter' => { 93 => 0xfe58, 347 => 'MoireFilter' },
	'monitordisplayoff' => { 148 => 0x4c },
	'monitorofftime' => { 219 => '18.2', 220 => '3.1', 226 => '3.1' },
	'monochromecontrast' => { 85 => 0x3c },
	'monochromefiltereffect' => { 85 => 0x3a, 279 => 0x73 },
	'monochromelinear' => { 85 => 0x3d },
	'monochromeoutputhighlightpoint' => { 85 => 0x41 },
	'monochromeoutputshadowpoint' => { 85 => 0x42 },
	'monochromerawhighlight' => { 85 => 0x7a },
	'monochromerawhighlightpoint' => { 85 => 0x3f },
	'monochromerawshadow' => { 85 => 0x83 },
	'monochromerawshadowpoint' => { 85 => 0x40 },
	'monochromesharpness' => { 85 => 0x3e },
	'monochrometoning' => { 279 => 0x74 },
	'monochrometoningeffect' => { 85 => 0x3b },
	'monochromeunsharpmaskfineness' => { 85 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 85 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 85 => 0xb4 },
	'monthdaycreated' => { 109 => 0x12, 118 => 0xe },
	'moonphase' => { 292 => 0x12 },
	'morepermissions' => { 345 => 'morePermissions' },
	'motionsensitivity' => { 292 => 0x29 },
	'multiburstimageheight' => { 319 => 0x1002 },
	'multiburstimagewidth' => { 319 => 0x1001 },
	'multiburstmode' => { 319 => 0x1000 },
	'multicontrollerwhilemetering' => { 66 => 0x517 },
	'multiexposureautogain' => { 180 => 0x3 },
	'multiexposuremode' => { 180 => 0x1 },
	'multiexposureshots' => { 180 => 0x2 },
	'multiframenoisereduction' => { 310 => 0x35, 319 => 0x200b, 322 => 0x15 },
	'multifunctionlock' => { 66 => 0x70f },
	'multipleexposuremode' => { 233 => 0x101c },
	'multipleexposureset' => { 260 => '10.1' },
	'multisample' => { 184 => 0x40 },
	'multiselector' => { 219 => '9.4', 224 => '27.4' },
	'multiselectorliveview' => { 219 => '4.3' },
	'multiselectorplaybackmode' => { 219 => ['13.5','9.2'], 224 => '27.2' },
	'multiselectorshootmode' => { 219 => '9.1', 224 => '27.1' },
	'mycolormode' => { 53 => 0x2 },
	'nativedigest' => { 351 => 'NativeDigest', 365 => 'NativeDigest' },
	'ncdfileinfo' => { 107 => 0x414 },
	'ndfilter' => { 60 => 0x1c },
	'nefbitdepth' => { 179 => 0xe22 },
	'nefcompression' => { 179 => 0x93 },
	'neflinearizationtable' => { 179 => 0x96 },
	'neutraldensityfilter' => { 279 => 0x88 },
	'neutraloutputhighlightpoint' => { 85 => 0x2f },
	'neutraloutputshadowpoint' => { 85 => 0x30 },
	'neutralrawcolortone' => { 85 => 0x28 },
	'neutralrawcontrast' => { 85 => 0x2a },
	'neutralrawhighlight' => { 85 => 0x78 },
	'neutralrawhighlightpoint' => { 85 => 0x2d },
	'neutralrawlinear' => { 85 => 0x2b },
	'neutralrawsaturation' => { 85 => 0x29 },
	'neutralrawshadow' => { 85 => 0x81 },
	'neutralrawshadowpoint' => { 85 => 0x2e },
	'neutralrawsharpness' => { 85 => 0x2c },
	'neutralunsharpmaskfineness' => { 85 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 85 => 0xa8 },
	'neutraunsharpmaskstrength' => { 85 => 0xa4 },
	'newrawimagedigest' => { 93 => 0xc7a7 },
	'newsphotoversion' => { 103 => 0x0 },
	'nickname' => { 367 => 'Nickname' },
	'nikoncapturedata' => { 179 => 0xe01 },
	'nikoncaptureeditversions' => { 179 => 0xe13 },
	'nikoncaptureoutput' => { 179 => 0xe1e },
	'nikoncaptureversion' => { 179 => 0xe09 },
	'nikoniccprofile' => { 179 => 0xe1d },
	'nikonimagesize' => { 191 => '723.1', 192 => '732.1', 199 => 0x2c4 },
	'noisefilter' => { 229 => 0x527 },
	'noiseprofile' => { 93 => 0xc761 },
	'noisereduction' => { 98 => 0x100b, 146 => 0xb0, 147 => 0x60, 148 => 0x3f, 179 => 0x95, 212 => 0x753dcbc0, 213 => 0x17, 229 => 0x50a, 234 => 0x103a, 248 => 0x2d, 279 => 0x49, 298 => 0x2a },
	'noisereduction2' => { 233 => 0x1010 },
	'noisereductionapplied' => { 93 => 0xc6f7 },
	'noisereductionintensity' => { 213 => 0x9 },
	'noisereductionmethod' => { 213 => 0x11 },
	'noisereductionmode' => { 333 => 0x801e },
	'noisereductionsharpness' => { 213 => 0xd },
	'noisereductionvalue' => { 333 => 0x8027 },
	'nomemorycard' => { 219 => '22.1', 220 => '0.3', 221 => '2.4', 222 => '3.2', 223 => '3.2', 224 => '33.7', 225 => '3.2', 226 => '0.3', 228 => '4.5' },
	'nominalmaxaperture' => { 270 => 0xa },
	'nominalminaperture' => { 270 => '10.1' },
	'notes' => { 334 => 'Notes', 342 => 'notes' },
	'npages' => { 374 => 'NPages' },
	'nrwdata' => { 179 => 0x14 },
	'nullrecord' => { 79 => 0x0 },
	'number' => { 360 => 'number' },
	'numberofbeats' => { 369 => 'numberOfBeats' },
	'numberoffocuspoints' => { 223 => '0.2', 225 => '0.3' },
	'numfacepositions' => { 242 => 0x0 },
	'numindexentries' => { 103 => 0x54 },
	'object' => { 360 => 'object' },
	'objectattributereference' => { 101 => 0x4 },
	'objectcycle' => { 101 => 0x4b },
	'objectdistance' => { 88 => 0x6, 89 => 0x2022 },
	'objectname' => { 101 => 0x5 },
	'objectpreviewdata' => { 101 => 0xca },
	'objectpreviewfileformat' => { 101 => 0xc8 },
	'objectpreviewfileversion' => { 101 => 0xc9 },
	'objecttypereference' => { 101 => 0x3 },
	'occurrence' => { 92 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 92 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 92 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 92 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 92 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 92 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 92 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 92 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 92 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 92 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 92 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 92 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 92 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 92 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 92 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 92 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 92 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 92 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 92 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 92 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 92 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 92 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 92 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 92 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 351 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 351 => [\'OECF','OECFNames'] },
	'oecfrows' => { 351 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 351 => [\'OECF','OECFValues'] },
	'offsetschema' => { 93 => 0xea1d },
	'okbutton' => { 225 => '15.1', 228 => '16.1' },
	'oldsubfiletype' => { 93 => 0xff },
	'olympusimageheight' => { 234 => 0x102f },
	'olympusimagewidth' => { 234 => 0x102e },
	'onetouchwb' => { 234 => 0x302 },
	'opticalzoom' => { 111 => 0xfa3d, 113 => [0x6006,0xf006], 114 => 0x1000, 115 => 0xf, 118 => 0x1e, 130 => 'OpticalZoom' },
	'opticalzoomcode' => { 60 => 0xa },
	'opticalzoommode' => { 248 => 0x34 },
	'opticalzoomon' => { 303 => 0x219 },
	'optionenddate' => { 362 => 'optionEndDate' },
	'opto-electricconvfactor' => { 351 => 'OECF' },
	'ordernumber' => { 98 => 0x8002 },
	'organisationinimagecode' => { 356 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 356 => 'OrganisationInImageName' },
	'organization' => { 360 => 'organization' },
	'orientation' => { 93 => 0x112, 252 => 0x112, 365 => 'Orientation' },
	'orientation2' => { 322 => 0x2e },
	'orientationlinkedafpoint' => { 66 => 0x516 },
	'originalbestqualitysize' => { 93 => 0xc792 },
	'originaldecisiondata' => { 90 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 49 => 0x83 },
	'originaldefaultcropsize' => { 93 => 0xc793 },
	'originaldefaultfinalsize' => { 93 => 0xc791 },
	'originaldirectory' => { 246 => 0x408 },
	'originaldocumentid' => { 370 => 'OriginalDocumentID' },
	'originalfilename' => { 79 => 0x816, 107 => 0x3e9, 119 => 0x20, 246 => 0x407, 338 => 'OriginalFilename' },
	'originalimageheight' => { 62 => 0xc, 97 => 0x1 },
	'originalimagewidth' => { 62 => 0xb, 97 => 0x0 },
	'originalrawfiledata' => { 93 => 0xc68c },
	'originalrawfiledigest' => { 93 => 0xc71d },
	'originalrawfilename' => { 93 => 0xc68b },
	'originaltransmissionreference' => { 101 => 0x67 },
	'originatingprogram' => { 101 => 0x41 },
	'originplatform' => { 360 => 'originPlatform' },
	'os' => { 349 => 'os' },
	'otherconditions' => { 359 => 'OtherConditions' },
	'otherconstraints' => { 359 => 'OtherConstraints' },
	'otherimage' => { 90 => 'OtherImage' },
	'otherimageinfo' => { 359 => 'OtherImageInfo' },
	'otherimagelength' => { 93 => 0x202 },
	'otherimagestart' => { 93 => 0x201 },
	'otherlicensedocuments' => { 359 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 359 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 359 => 'OtherLicenseRequirements' },
	'outcue' => { 369 => 'outCue' },
	'outcuescale' => { 369 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 369 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 158 => 0x3 },
	'outputimagewidth' => { 158 => 0x2 },
	'outputresolution' => { 158 => 0x4 },
	'owner' => { 373 => 'Owner' },
	'ownerid' => { 101 => 0xbc },
	'ownername' => { 12 => 0x10f, 49 => 0x9, 79 => 0x810, 93 => [0xa430,0xfde8], 123 => 'OwnerName', 344 => 'OwnerName' },
	'padding' => { 93 => 0xea1c },
	'pageimage' => { 367 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 367 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 367 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 367 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 367 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 367 => 'PageInfo' },
	'pagename' => { 93 => 0x11d },
	'pagenumber' => { 93 => 0x129 },
	'pagerange' => { 360 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 347 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskcenterweight' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskflow' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskradius' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskvalue' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskwhat' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskzerox' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 347 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 248 => 0x26 },
	'panasonicimageheight' => { 248 => 0x4c },
	'panasonicimagewidth' => { 248 => 0x4b },
	'panasonicrawversion' => { 252 => 0x1 },
	'panasonictitle' => { 93 => 0xc6d2 },
	'panasonictitle2' => { 93 => 0xc6d3 },
	'panoramacropbottom' => { 323 => 0x7 },
	'panoramacropleft' => { 323 => 0x4 },
	'panoramacropright' => { 323 => 0x6 },
	'panoramacroptop' => { 323 => 0x5 },
	'panoramadirection' => { 56 => 0x5, 323 => 0x3 },
	'panoramaframeheight' => { 323 => 0x9 },
	'panoramaframenumber' => { 56 => 0x2 },
	'panoramaframewidth' => { 323 => 0x8 },
	'panoramafullheight' => { 323 => 0x2 },
	'panoramafullwidth' => { 323 => 0x1 },
	'panoramamode' => { 109 => 0x3c, 229 => 0x601 },
	'panoramasize3d' => { 310 => 0x38 },
	'panoramasourceheight' => { 323 => 0xb },
	'panoramasourcewidth' => { 323 => 0xa },
	'panoramicstitchcameramotion' => { 141 => 'PanoramicStitchCameraMotion', 142 => 0x1 },
	'panoramicstitchmaptype' => { 141 => 'PanoramicStitchMapType', 142 => 0x2 },
	'panoramicstitchphi0' => { 141 => 'PanoramicStitchPhi0', 142 => 0x5 },
	'panoramicstitchphi1' => { 141 => 'PanoramicStitchPhi1', 142 => 0x6 },
	'panoramicstitchtheta0' => { 141 => 'PanoramicStitchTheta0', 142 => 0x3 },
	'panoramicstitchtheta1' => { 141 => 'PanoramicStitchTheta1', 142 => 0x4 },
	'panoramicstitchversion' => { 142 => 0x0 },
	'pantry' => { 370 => 'Pantry' },
	'parallax' => { 98 => 0xb211 },
	'parametricdarks' => { 347 => 'ParametricDarks' },
	'parametrichighlights' => { 347 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 347 => 'ParametricHighlightSplit' },
	'parametriclights' => { 347 => 'ParametricLights' },
	'parametricmidtonesplit' => { 347 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 347 => 'ParametricShadows' },
	'parametricshadowsplit' => { 347 => 'ParametricShadowSplit' },
	'parentmeid' => { 338 => 'ParentMEID' },
	'parentreference1' => { 354 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 354 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'patientbirthdate' => { 335 => 'PatientDOB' },
	'patientid' => { 335 => 'PatientID' },
	'patientname' => { 335 => 'PatientName' },
	'patientsex' => { 335 => 'PatientSex' },
	'pdfversion' => { 357 => 'PDFVersion' },
	'pentaximagesize' => { 279 => 0x9 },
	'pentaxmodelid' => { 259 => 0x0, 279 => 0x5 },
	'pentaxmodeltype' => { 279 => 0x1 },
	'pentaxversion' => { 279 => 0x0 },
	'people' => { 340 => 'People' },
	'peripheralillumcentralradius' => { 333 => 0x8030 },
	'peripheralillumcentralvalue' => { 333 => 0x8031 },
	'peripheralillumination' => { 85 => 0x68 },
	'peripheralilluminationon' => { 85 => 0x64 },
	'peripheralillumperiphvalue' => { 333 => 0x8032 },
	'peripherallighting' => { 62 => 0x2 },
	'peripherallightingsetting' => { 63 => 0x5 },
	'peripherallightingvalue' => { 62 => 0x6 },
	'permissions' => { 362 => 'permissions' },
	'permits' => { 345 => 'permits' },
	'person' => { 360 => 'person' },
	'personality' => { 338 => 'Personality' },
	'personinimage' => { 356 => 'PersonInImage' },
	'perspectivehorizontal' => { 347 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 347 => 'PerspectiveRotate' },
	'perspectivescale' => { 347 => 'PerspectiveScale' },
	'perspectivevertical' => { 347 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 74 => 0x1 },
	'pf10retainprogramshift' => { 74 => 0xb },
	'pf13drivepriority' => { 74 => 0xe },
	'pf14disablefocussearch' => { 74 => 0xf },
	'pf15disableafassistbeam' => { 74 => 0x10 },
	'pf16autofocuspointshoot' => { 74 => 0x11 },
	'pf17disableafpointsel' => { 74 => 0x12 },
	'pf18enableautoafpointsel' => { 74 => 0x13 },
	'pf19continuousshootspeed' => { 74 => 0x14 },
	'pf19shootingspeedhigh' => { 73 => 0xa },
	'pf19shootingspeedlow' => { 73 => 0x9 },
	'pf1disableshootingmodes' => { 74 => 0x2 },
	'pf1value' => { 73 => 0x1 },
	'pf20limitcontinousshots' => { 74 => 0x15 },
	'pf20maxcontinousshots' => { 73 => 0xb },
	'pf21enablequietoperation' => { 74 => 0x16 },
	'pf23felocktime' => { 73 => 0xd },
	'pf23postreleasetime' => { 73 => 0xe },
	'pf23settimerlengths' => { 74 => 0x18 },
	'pf23shutterbuttontime' => { 73 => 0xc },
	'pf24lightlcdduringbulb' => { 74 => 0x19 },
	'pf25aemode' => { 73 => 0xf },
	'pf25afmode' => { 73 => 0x12 },
	'pf25afpointsel' => { 73 => 0x13 },
	'pf25colormatrix' => { 73 => 0x17 },
	'pf25defaultclearsettings' => { 74 => 0x1a },
	'pf25drivemode' => { 73 => 0x11 },
	'pf25imagesize' => { 73 => 0x14 },
	'pf25meteringmode' => { 73 => 0x10 },
	'pf25parameters' => { 73 => 0x16 },
	'pf25wbmode' => { 73 => 0x15 },
	'pf26shortenreleaselag' => { 74 => 0x1b },
	'pf27reversedialrotation' => { 74 => 0x1c },
	'pf27value' => { 73 => 0x18 },
	'pf28noquickdialexpcomp' => { 74 => 0x1d },
	'pf29quickdialswitchoff' => { 74 => 0x1e },
	'pf2disablemeteringmodes' => { 74 => 0x3 },
	'pf2value' => { 73 => 0x2 },
	'pf30enlargementmode' => { 74 => 0x1f },
	'pf31originaldecisiondata' => { 74 => 0x20 },
	'pf3manualexposuremetering' => { 74 => 0x4 },
	'pf3value' => { 73 => 0x3 },
	'pf4exposuretimelimits' => { 74 => 0x5 },
	'pf4exposuretimemax' => { 73 => 0x5 },
	'pf4exposuretimemin' => { 73 => 0x4 },
	'pf5aperturelimits' => { 74 => 0x6 },
	'pf5aperturemax' => { 73 => 0x7 },
	'pf5aperturemin' => { 73 => 0x6 },
	'pf6presetshootingmodes' => { 74 => 0x7 },
	'pf7bracketcontinuousshoot' => { 74 => 0x8 },
	'pf8bracketshots' => { 73 => 0x8 },
	'pf8setbracketshots' => { 74 => 0x9 },
	'pf9changebracketsequence' => { 74 => 0xa },
	'phasedetectaf' => { 156 => 0x6 },
	'phonenumber' => { 124 => 'Phone' },
	'photoeffect' => { 27 => 0x28 },
	'photoeffecthistoryxml' => { 212 => 0xe9651831 },
	'photoeffects' => { 212 => 0xab5eca5e },
	'photoeffectsblue' => { 214 => 0x8 },
	'photoeffectsgreen' => { 214 => 0x6 },
	'photoeffectsred' => { 214 => 0x4 },
	'photoeffectstype' => { 214 => 0x0 },
	'photoinfoplayback' => { 219 => '17.6', 224 => '33.6' },
	'photometricinterpretation' => { 93 => 0x106, 365 => 'PhotometricInterpretation' },
	'photoshopquality' => { 288 => 0x0 },
	'photostyle' => { 248 => 0x89 },
	'picklabel' => { 350 => 'PickLabel' },
	'pictinfo' => { 303 => 0x208 },
	'picturecontrol' => { 212 => 0xe2173c47 },
	'picturecontrolactive' => { 215 => 0x0 },
	'picturecontroladjust' => { 181 => 0x30 },
	'picturecontrolbase' => { 181 => 0x18 },
	'picturecontroldata' => { 179 => [0xbd,0x23] },
	'picturecontrolmode' => { 215 => 0x13 },
	'picturecontrolname' => { 181 => 0x4 },
	'picturecontrolquickadjust' => { 181 => 0x31 },
	'pictureeffect' => { 319 => 0x200e },
	'picturefinish' => { 146 => 0x71 },
	'picturemode' => { 98 => 0x1031, 229 => 0x520, 279 => [0xb,0x33], 304 => 0x3d },
	'picturemode2' => { 260 => 0x0 },
	'picturemodebwfilter' => { 229 => 0x525 },
	'picturemodecontrast' => { 229 => 0x523 },
	'picturemodeeffect' => { 229 => 0x52d },
	'picturemodehue' => { 229 => 0x522 },
	'picturemodesaturation' => { 229 => 0x521 },
	'picturemodesharpness' => { 229 => 0x524 },
	'picturemodetone' => { 229 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0xf4, 7 => 0x6c, 8 => 0x86, 9 => 0x73, 13 => 0xab, 14 => 0xa7, 15 => 0xb0, 16 => 0x6c, 17 => 0xa7, 18 => 0xf4, 19 => 0xb3, 21 => 0xf4, 22 => 0xfa, 58 => 0xa, 85 => 0x2 },
	'picturewizard' => { 301 => 0x21 },
	'picturewizardcolor' => { 299 => 0x1 },
	'picturewizardcontrast' => { 299 => 0x4 },
	'picturewizardmode' => { 299 => 0x0 },
	'picturewizardsaturation' => { 299 => 0x2 },
	'picturewizardsharpness' => { 299 => 0x3 },
	'pitchangle' => { 278 => 0x2 },
	'planarconfiguration' => { 93 => 0x11c, 365 => 'PlanarConfiguration' },
	'platenames' => { 374 => 'PlateNames' },
	'playbackmenustime' => { 221 => '20.1', 222 => '21.1', 223 => '21.1' },
	'playbackmonitorofftime' => { 224 => '8.1', 225 => '35.1', 228 => '21.1' },
	'playdisplay' => { 148 => 0x4e },
	'plusversion' => { 359 => 'Version' },
	'pmversion' => { 287 => 'PMVersion' },
	'pngwarning' => { 240 => 'Warning' },
	'portraitoutputhighlightpoint' => { 85 => 0x1d },
	'portraitoutputshadowpoint' => { 85 => 0x1e },
	'portraitrawcolortone' => { 85 => 0x16 },
	'portraitrawcontrast' => { 85 => 0x18 },
	'portraitrawhighlight' => { 85 => 0x76 },
	'portraitrawhighlightpoint' => { 85 => 0x1b },
	'portraitrawlinear' => { 85 => 0x19 },
	'portraitrawsaturation' => { 85 => 0x17 },
	'portraitrawshadow' => { 85 => 0x7f },
	'portraitrawshadowpoint' => { 85 => 0x1c },
	'portraitrawsharpness' => { 85 => 0x1a },
	'portraitrefiner' => { 89 => 0x302b },
	'portraitunsharpmaskfineness' => { 85 => 0x9a },
	'portraitunsharpmaskstrength' => { 85 => 0x98 },
	'portraitunsharpmaskthreshold' => { 85 => 0x9c },
	'poseheadingdegrees' => { 337 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 337 => 'PosePitchDegrees' },
	'poserolldegrees' => { 337 => 'PoseRollDegrees' },
	'postalcode' => { 128 => 'PostalCode' },
	'postcropvignetteamount' => { 347 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 347 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 347 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 347 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 347 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 347 => 'PostCropVignetteStyle' },
	'powersource' => { 258 => '0.1' },
	'poweruptime' => { 179 => 0xb6 },
	'precaptureframes' => { 234 => 0x300 },
	'predictor' => { 93 => 0x13d },
	'preflashreturnstrength' => { 192 => 0x28a },
	'prefs' => { 101 => 0xdd, 287 => 'Prefs' },
	'preservedfilename' => { 370 => 'PreservedFileName' },
	'presetwhitebalance' => { 148 => 0x24, 333 => 0x8002 },
	'presetwhitebalanceadj' => { 333 => 0x8014 },
	'previewapplicationname' => { 93 => 0xc716 },
	'previewapplicationversion' => { 93 => 0xc717 },
	'previewbutton' => { 219 => ['14.1','15.1'], 224 => '29.1', 225 => '14.1' },
	'previewbuttonplusdials' => { 219 => ['14.2','15.2'], 224 => '31.2' },
	'previewcolorspace' => { 93 => 0xc71a },
	'previewcropbottom' => { 286 => 0xef },
	'previewcropleft' => { 286 => 0xec },
	'previewcropright' => { 286 => 0xee },
	'previewcroptop' => { 286 => 0xed },
	'previewdatetime' => { 93 => 0xc71b },
	'previewimage' => { 89 => 0x2000, 90 => 'PreviewImage', 94 => 'PreviewImage', 96 => 0x4, 133 => 'data', 150 => 0x81, 234 => 0x280, 247 => 0x300, 319 => 0x2001 },
	'previewimageborders' => { 279 => 0x3e },
	'previewimageheight' => { 57 => 0x4, 111 => 0xfa58 },
	'previewimagelength' => { 57 => 0x2, 89 => 0x3, 93 => [0x117,0x202], 150 => 0x89, 182 => 0x202, 229 => 0x102, 234 => 0x1037, 279 => 0x3, 295 => 0x1e, 300 => 0x3, 304 => [0x1b,0x1d], 311 => 0x202 },
	'previewimagename' => { 133 => '1Name' },
	'previewimagesize' => { 89 => 0x2, 116 => 0x2, 133 => 'ImageSize', 279 => 0x2, 304 => [0x1c,0x1e], 319 => 0xb02c },
	'previewimagestart' => { 57 => 0x5, 89 => 0x4, 93 => [0x111,0x201], 150 => 0x88, 182 => 0x201, 229 => 0x101, 234 => 0x1036, 279 => 0x4, 295 => 0x1c, 300 => 0x2, 304 => [0x1a,0x1c], 311 => 0x201 },
	'previewimagetype' => { 133 => '0Type' },
	'previewimagevalid' => { 229 => 0x100, 234 => 0x1035 },
	'previewimagewidth' => { 57 => 0x3, 111 => 0xfa57 },
	'previewquality' => { 57 => 0x1 },
	'previewsettingsdigest' => { 93 => 0xc719 },
	'previewsettingsname' => { 93 => 0xc718 },
	'primaryafpoint' => { 156 => 0x7 },
	'primarychromaticities' => { 93 => 0x13f, 365 => 'PrimaryChromaticities' },
	'printim' => { 93 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 148 => 0x1d, 308 => 0x28 },
	'privatertkinfo' => { 339 => 'privateRTKInfo' },
	'processingsoftware' => { 93 => 0xb },
	'processversion' => { 347 => 'ProcessVersion' },
	'producer' => { 238 => 'Producer', 357 => 'Producer' },
	'productid' => { 102 => 0x32 },
	'productioncode' => { 259 => 0x2 },
	'productorserviceconstraints' => { 359 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 93 => 0xc6f4 },
	'profilecopyright' => { 93 => 0xc6fe },
	'profileembedpolicy' => { 93 => 0xc6fd },
	'profilehuesatmapdata1' => { 93 => 0xc6fa },
	'profilehuesatmapdata2' => { 93 => 0xc6fb },
	'profilehuesatmapdims' => { 93 => 0xc6f9 },
	'profilehuesatmapencoding' => { 93 => 0xc7a3 },
	'profilelooktabledata' => { 93 => 0xc726 },
	'profilelooktabledims' => { 93 => 0xc725 },
	'profilelooktableencoding' => { 93 => 0xc7a4 },
	'profilename' => { 93 => 0xc6f8 },
	'profiletonecurve' => { 93 => 0xc6fc },
	'programiso' => { 248 => 0x3c },
	'programline' => { 260 => '1.1' },
	'programmode' => { 153 => 0x5 },
	'programshift' => { 179 => 0xd },
	'programversion' => { 101 => 0x46 },
	'prohibits' => { 345 => 'prohibits' },
	'projectiontype' => { 337 => 'ProjectionType' },
	'projectname' => { 369 => 'projectName' },
	'projectref' => { 369 => 'projectRef' },
	'projectrefpath' => { 369 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 369 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 359 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 359 => 'PropertyReleaseStatus' },
	'province-state' => { 101 => 0x5f },
	'publicationdate' => { 360 => 'publicationDate' },
	'publicationname' => { 360 => 'publicationName' },
	'publisher' => { 348 => 'publisher' },
	'pulldown' => { 369 => 'pullDown' },
	'quality' => { 0 => 0x1, 27 => 0x3, 88 => 0x2, 89 => 0x3002, 98 => 0x1000, 109 => 0x9, 179 => 0x4, 202 => 0x3, 234 => 0x201, 244 => 0x300, 279 => 0x8, 284 => 0x2, 304 => 0x16, 308 => 0x56, 309 => 0x56, 310 => 0xb, 319 => 0x102 },
	'quality2' => { 326 => 0x29, 327 => 0x25 },
	'qualitymode' => { 89 => 0x8 },
	'quantizationmethod' => { 103 => 0x78 },
	'quickadjust' => { 215 => 0x2a },
	'quickcontroldialinmeter' => { 66 => 0x703 },
	'quickshot' => { 303 => 0x213 },
	'rangefinder' => { 221 => '4.1', 222 => '5.1', 223 => '5.1' },
	'rasterizedcaption' => { 101 => 0x7d },
	'rating' => { 93 => 0x4746, 286 => 0xdf, 319 => 0x2002, 342 => 'rating', 349 => 'rating', 367 => 'Rating' },
	'ratingpercent' => { 93 => 0x4749, 143 => 'Rating' },
	'rawandjpgrecording' => { 64 => 0x8, 150 => 0x109, 260 => 0xd },
	'rawbrightnessadj' => { 84 => 0x38 },
	'rawcoloradj' => { 84 => 0x2e },
	'rawcropbottom' => { 286 => 0xd4 },
	'rawcropleft' => { 286 => 0xd1 },
	'rawcropright' => { 286 => 0xd3 },
	'rawcroptop' => { 286 => 0xd2 },
	'rawcustomsaturation' => { 84 => 0x30 },
	'rawcustomtone' => { 84 => 0x34 },
	'rawdatauniqueid' => { 93 => 0xc65d },
	'rawdepth' => { 152 => 0x10 },
	'rawdevautogradation' => { 236 => 0x119 },
	'rawdevcolorspace' => { 235 => 0x108, 236 => 0x109 },
	'rawdevcontrastvalue' => { 235 => 0x106, 236 => 0x105 },
	'rawdeveditstatus' => { 235 => 0x10b },
	'rawdevelopmentprocess' => { 279 => 0x62 },
	'rawdevengine' => { 235 => 0x109, 236 => 0x10b },
	'rawdevexposurebiasvalue' => { 235 => 0x100, 236 => 0x100 },
	'rawdevgradation' => { 236 => 0x112 },
	'rawdevgraypoint' => { 235 => 0x103, 236 => 0x104 },
	'rawdevmemorycoloremphasis' => { 235 => 0x105, 236 => 0x108 },
	'rawdevnoisereduction' => { 235 => 0x10a, 236 => 0x10a },
	'rawdevpicturemode' => { 236 => 0x10c },
	'rawdevpm_bwfilter' => { 236 => 0x110 },
	'rawdevpmcontrast' => { 236 => 0x10e },
	'rawdevpmnoisefilter' => { 236 => 0x120 },
	'rawdevpmpicturetone' => { 236 => 0x111 },
	'rawdevpmsaturation' => { 236 => 0x10d },
	'rawdevpmsharpness' => { 236 => 0x10f },
	'rawdevsaturation3' => { 236 => 0x113 },
	'rawdevsaturationemphasis' => { 235 => 0x104, 236 => 0x107 },
	'rawdevsettings' => { 235 => 0x10c },
	'rawdevsharpnessvalue' => { 235 => 0x107, 236 => 0x106 },
	'rawdevversion' => { 235 => 0x0, 236 => 0x0 },
	'rawdevwbfineadjustment' => { 235 => 0x102, 236 => 0x103 },
	'rawdevwhitebalance' => { 236 => 0x101 },
	'rawdevwhitebalancevalue' => { 235 => 0x101, 236 => 0x102 },
	'rawfile' => { 93 => 0xfe4c },
	'rawfilename' => { 347 => 'RawFileName' },
	'rawimagecenter' => { 179 => 0x99 },
	'rawimagedigest' => { 93 => 0xc71c },
	'rawimagesize' => { 279 => 0x39 },
	'rawinfoversion' => { 237 => 0x0 },
	'rawjpgheight' => { 81 => 0x4 },
	'rawjpgquality' => { 44 => 0x6, 81 => 0x1 },
	'rawjpgsize' => { 44 => 0x7, 81 => 0x2 },
	'rawjpgwidth' => { 81 => 0x3 },
	'rawmeasuredrggb' => { 32 => 0x26a, 34 => 0x280, 36 => 0x194, 37 => 0x1ad },
	'rawrppused' => { 342 => 'rawrppused' },
	'rawtopreviewgain' => { 93 => 0xc7a8 },
	'reardisplay' => { 219 => '12.3' },
	'recognizedface1age' => { 243 => 0x20 },
	'recognizedface1name' => { 243 => 0x4 },
	'recognizedface1position' => { 243 => 0x18 },
	'recognizedface2age' => { 243 => 0x50 },
	'recognizedface2name' => { 243 => 0x34 },
	'recognizedface2position' => { 243 => 0x48 },
	'recognizedface3age' => { 243 => 0x80 },
	'recognizedface3name' => { 243 => 0x64 },
	'recognizedface3position' => { 243 => 0x78 },
	'recognizedfaceflags' => { 248 => 0x63 },
	'recommendedexposureindex' => { 93 => 0x8832 },
	'record' => { 92 => 'Record' },
	'recordbasisofrecord' => { 92 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 92 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 92 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 92 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 92 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 92 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 148 => 0x4d },
	'recorddynamicproperties' => { 92 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 79 => 0x1804 },
	'recordinformationwithheld' => { 92 => [\'Record','RecordInformationWithheld'] },
	'recordingmode' => { 88 => 0x1, 284 => 0x1 },
	'recordinstitutioncode' => { 92 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 92 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 27 => 0x9, 89 => 0x3000 },
	'recordownerinstitutioncode' => { 92 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 303 => 0x217 },
	'redbalance' => { 163 => 0x270, 234 => 0x1017, 252 => 0x11, 279 => 0x1c },
	'redcurvelimits' => { 84 => 0x18a },
	'redcurvepoints' => { 84 => 0x160 },
	'redeyecorrection' => { 216 => 0x0 },
	'redeyeinfo' => { 347 => 'RedEyeInfo' },
	'redeyereduction' => { 148 => 0x41, 310 => 0x28 },
	'redhue' => { 347 => 'RedHue' },
	'redsaturation' => { 347 => 'RedSaturation' },
	'reductionmatrix1' => { 93 => 0xc625 },
	'reductionmatrix2' => { 93 => 0xc626 },
	'reelname' => { 93 => 0xc789 },
	'reference1' => { 354 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 354 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 93 => 0x214, 365 => 'ReferenceBlackWhite' },
	'referencedate' => { 101 => 0x2f },
	'referencenumber' => { 101 => 0x32 },
	'references' => { 124 => 'References' },
	'referenceservice' => { 101 => 0x2d },
	'regionappliedtodimensions' => { 139 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 139 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 139 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 139 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 139 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 139 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 139 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 139 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 139 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 139 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 139 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 139 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 359 => 'RegionConstraints' },
	'regiondescription' => { 139 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 139 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 139 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 139 => 'Regions' },
	'regioninfodateregionsvalid' => { 140 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 140 => 'RegionInfo' },
	'regioninforegions' => { 140 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 139 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 139 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 140 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 140 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 140 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 140 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 140 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 139 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 139 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 356 => 'RegistryId' },
	'registryitemid' => { 356 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 356 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 122 => 'data' },
	'relatedaudiofilename' => { 122 => '1Name' },
	'relatedaudiofiletype' => { 122 => '0Type' },
	'relatedimagefileformat' => { 93 => 0x1000 },
	'relatedimageheight' => { 93 => 0x1002 },
	'relatedimagewidth' => { 93 => 0x1001 },
	'relatedresourceid' => { 92 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 93 => 0xa004, 351 => 'RelatedSoundFile' },
	'relatedvideofile' => { 136 => 'data' },
	'relatedvideofilename' => { 136 => '1Name' },
	'relatedvideofiletype' => { 136 => '0Type' },
	'relation' => { 348 => 'relation' },
	'relationshipaccordingto' => { 92 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 92 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 92 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 92 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 369 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 369 => 'relativeTimestamp' },
	'relativetimestampscale' => { 369 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 369 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 219 => '17.8', 224 => '33.8', 225 => '17.6' },
	'releasedate' => { 101 => 0x1e, 369 => 'releaseDate' },
	'releasemode' => { 89 => 0x3001, 319 => 0xb049 },
	'releasemode2' => { 326 => 0x10, 327 => 0x10 },
	'releasesetting' => { 79 => 0x1016 },
	'releasetime' => { 101 => 0x23 },
	'remoteonduration' => { 220 => '3.4', 221 => '17.2', 222 => '18.2', 223 => '18.2', 225 => '18.2', 226 => '4.3', 228 => '19.2' },
	'renditionclass' => { 370 => 'RenditionClass' },
	'renditionof' => { 370 => 'RenditionOf' },
	'renditionofalternatepaths' => { 370 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 370 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 370 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 370 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 370 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 370 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 370 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 370 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 370 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 370 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 370 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 370 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 370 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 370 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 370 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 370 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 370 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 370 => 'RenditionParams' },
	'repeatingflashcount' => { 168 => 0xd, 169 => 0xe, 170 => 0xe, 224 => '17.2', 225 => '24.2', 226 => '9.2', 227 => '24.2', 228 => '25.2' },
	'repeatingflashcountbuilt-in' => { 200 => 0x4db },
	'repeatingflashcountexternal' => { 200 => 0x4c3 },
	'repeatingflashoutput' => { 224 => '17.1', 225 => '24.1', 226 => '9.1', 227 => '24.1', 228 => '25.1' },
	'repeatingflashoutputexternal' => { 200 => 0x4c0 },
	'repeatingflashrate' => { 168 => 0xc, 169 => 0xd, 170 => 0xd, 224 => '18.1', 225 => '25.1', 226 => '10.1', 227 => '25.1', 228 => '26.1' },
	'repeatingflashratebuilt-in' => { 200 => 0x4da },
	'repeatingflashrateexternal' => { 200 => 0x4c2 },
	'requires' => { 345 => 'requires' },
	'resampleparams' => { 369 => 'resampleParams' },
	'resampleparamsquality' => { 369 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 303 => 0x21e },
	'resolution' => { 129 => 'Resolution' },
	'resolutionmode' => { 304 => 0x4 },
	'resolutionunit' => { 93 => 0x128, 104 => 0x2, 365 => 'ResolutionUnit' },
	'resourceid' => { 92 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 92 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 92 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictions' => { 362 => 'restrictions' },
	'retouchhistory' => { 179 => 0x9e },
	'retouchinfo' => { 347 => 'RetouchInfo' },
	'reuse' => { 359 => 'Reuse' },
	'reuseallowed' => { 372 => 'ReuseAllowed' },
	'reuseprohibited' => { 362 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 223 => '5.2' },
	'reverseindicators' => { 219 => '12.1', 221 => '4.3', 222 => '5.2', 223 => '5.4', 224 => '33.5', 225 => '5.1', 228 => '6.2' },
	'reverseshutterspeedaperture' => { 223 => '5.3' },
	'revision' => { 349 => 'revision' },
	'rgbcurvelimits' => { 84 => 0x238 },
	'rgbcurvepoints' => { 84 => 0x20e },
	'richtextcomment' => { 353 => 'RichTextComment' },
	'ricohdate' => { 295 => 0x6 },
	'ricohimageheight' => { 295 => 0x2 },
	'ricohimagewidth' => { 295 => 0x0 },
	'rightascension' => { 132 => 'RightAscension' },
	'rights' => { 348 => 'rights' },
	'rightsagent' => { 360 => 'rightsAgent', 362 => 'rightsAgent' },
	'rightsowner' => { 362 => 'rightsOwner' },
	'rollangle' => { 278 => 0x1 },
	'romoperationmode' => { 79 => 0x80d },
	'rotation' => { 24 => 0x17, 25 => 0x18, 78 => 0x3, 84 => 0x26e, 97 => 0x4, 132 => 'Rotation', 146 => [0x65,0x50], 147 => 0x46, 148 => 0x5a, 151 => 0x10, 199 => '590.1', 212 => 0x76a43207, 248 => 0x30, 260 => '17.2', 286 => 0xd8, 308 => 0x3f, 309 => 0x3f, 318 => 0x10 },
	'routedto' => { 352 => 'RoutedTo' },
	'routing' => { 291 => 'Routing' },
	'routingnotes' => { 352 => 'RoutingNotes' },
	'rowsperstrip' => { 93 => 0x116 },
	'rpp' => { 342 => 'rpp' },
	'safetyshift' => { 66 => 0x108 },
	'safetyshiftinavortv' => { 64 => 0x10, 65 => 0x10, 67 => 0xf, 68 => 0x10, 71 => 0x10 },
	'samplebits' => { 122 => 'SampleBits' },
	'samplerate' => { 122 => 'SampleRate' },
	'samplesperpixel' => { 93 => 0x115, 365 => 'SamplesPerPixel' },
	'samplestructure' => { 103 => 0x5a },
	'sanyoquality' => { 303 => 0x201 },
	'sanyothumbnail' => { 303 => 0x100 },
	'saturation' => { 7 => 0x6e, 9 => 0x76, 27 => 0xe, 38 => 0x1, 88 => 0xd, 89 => [0x3013,0x1f], 93 => [0xa409,0xfe55], 98 => 0x1003, 123 => 'Saturation', 145 => 0x1f, 146 => 0x32, 147 => 0x28, 148 => 0x1a, 153 => 0x1, 179 => [0x94,0xaa], 181 => 0x35, 248 => 0x40, 250 => 0x300d, 279 => 0x1f, 284 => 0xd, 292 => 0x27, 295 => 0x28, 304 => 0x10, 308 => 0x1e, 309 => 0x1b, 319 => 0x2005, 347 => 'Saturation', 351 => 'Saturation' },
	'saturationadj' => { 84 => 0x116, 211 => 0x1, 215 => 0x2e, 333 => 0x8016 },
	'saturationadjustmentaqua' => { 347 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 347 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 347 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 347 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 347 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 347 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 347 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 347 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 16 => 0xfe, 54 => 0x68, 55 => 0x68 },
	'saturationlandscape' => { 16 => 0xfc, 54 => 0x38, 55 => 0x38 },
	'saturationmonochrome' => { 54 => 0x80, 55 => 0x80 },
	'saturationneutral' => { 16 => 0xfd, 54 => 0x50, 55 => 0x50 },
	'saturationportrait' => { 16 => 0xfb, 54 => 0x20, 55 => 0x20 },
	'saturationsetting' => { 237 => 0x1010, 310 => 0x11, 322 => 0x9 },
	'saturationstandard' => { 16 => 0xfa, 54 => 0x8, 55 => 0x8 },
	'saturationunknown' => { 55 => 0x98 },
	'saturationuserdef1' => { 16 => 0x100, 54 => 0x98, 55 => 0xb0 },
	'saturationuserdef2' => { 16 => 0x101, 54 => 0xb0, 55 => 0xc8 },
	'saturationuserdef3' => { 16 => 0x102, 54 => 0xc8, 55 => 0xe0 },
	'saveid' => { 370 => 'SaveID' },
	'scaletype' => { 369 => 'scaleType' },
	'scanimageenhancer' => { 184 => 0x60 },
	'scanningdirection' => { 103 => 0x64 },
	'scene' => { 355 => 'Scene', 369 => 'scene' },
	'scenearea' => { 232 => 0x211, 234 => 0x1031 },
	'sceneassist' => { 179 => 0x9c },
	'scenecapturetype' => { 93 => 0xa406, 351 => 'SceneCaptureType' },
	'scenedetect' => { 232 => 0x210, 234 => 0x1030 },
	'scenedetectdata' => { 232 => 0x212, 234 => 0x1033 },
	'scenemode' => { 111 => 0xfa02, 150 => 0x100, 179 => 0x8f, 229 => 0x509, 234 => 0x403, 248 => 0x8001, 254 => 0xf, 319 => 0xb023 },
	'scenemodeused' => { 113 => [0x6002,0xf002] },
	'sceneselect' => { 303 => 0x21f },
	'scenetype' => { 93 => 0xa301, 351 => 'SceneType' },
	'screentips' => { 219 => '12.7', 224 => '13.1', 225 => '4.4', 228 => '5.1' },
	'section' => { 360 => 'section' },
	'securityclassification' => { 93 => 0x9212 },
	'selectableafpoint' => { 66 => 0x509 },
	'selectafareaselectmode' => { 66 => 0x512 },
	'selftimer' => { 27 => 0x2, 248 => 0x2e, 303 => 0x214 },
	'selftimer2' => { 60 => 0x1d },
	'selftimerinterval' => { 225 => '19.2' },
	'selftimermode' => { 93 => 0x882b },
	'selftimershotcount' => { 221 => '18.2', 222 => '19.2', 223 => '19.2', 225 => '19.3', 228 => '20.2' },
	'selftimertime' => { 79 => 0x1806, 148 => 0x1f, 219 => '18.1', 220 => '3.3', 221 => '18.1', 222 => '19.1', 223 => '19.1', 224 => '7.2', 225 => '19.1', 226 => '3.3', 228 => '20.1' },
	'seminfo' => { 93 => 0x8546 },
	'sensingmethod' => { 93 => 0xa217, 351 => 'SensingMethod' },
	'sensitivityadjust' => { 279 => 0x40 },
	'sensitivitysteps' => { 260 => ['14.3','17.4'], 262 => 0x1 },
	'sensitivitytype' => { 93 => 0x8830 },
	'sensorareas' => { 301 => 0xa010 },
	'sensorbitdepth' => { 250 => 0x312d },
	'sensorbluelevel' => { 58 => 0x5 },
	'sensorcleaning' => { 72 => 0xd },
	'sensorfullheight' => { 106 => 0xf904 },
	'sensorfullwidth' => { 106 => 0xf903 },
	'sensorheight' => { 106 => 0xf901, 111 => 0xfa21, 152 => 0x8, 250 => 0x312c },
	'sensorpixelsize' => { 179 => 0x9a },
	'sensorredlevel' => { 58 => 0x4 },
	'sensorsize' => { 123 => 'SensorSize', 279 => 0x35 },
	'sensortemperature' => { 232 => 0x1500, 234 => 0x1007, 304 => [0x39,0x55] },
	'sensorwidth' => { 106 => 0xf900, 111 => 0xfa20, 152 => 0xa, 250 => 0x312b },
	'sequence' => { 292 => 0x7 },
	'sequencefilenumber' => { 326 => 0xc, 327 => 0xc },
	'sequenceimagenumber' => { 326 => 0x8, 327 => 0x8 },
	'sequencelength' => { 326 => 0x22, 327 => 0x1e },
	'sequencenumber' => { 60 => 0x9, 89 => 0x301c, 98 => 0x1101, 109 => 0x1d, 200 => 0x51c, 248 => 0x2b, 310 => [0x10c,0x30c], 319 => 0xb04a },
	'sequenceshotinterval' => { 303 => 0x224 },
	'sequentialshot' => { 303 => 0x20e },
	'serialnumber' => { 49 => 0xc, 79 => 0x180b, 93 => [0xa431,0xfde9], 106 => 0xfa04, 108 => 0xfa00, 110 => 0xc354, 111 => 0xfa19, 120 => 0x0, 123 => 'SerialNumber', 179 => [0xa0,0x1d], 230 => 0x101, 234 => [0x404,0x101a], 244 => 0x303, 250 => 0x3103, 279 => 0x229, 292 => 0x15, 296 => 0x5, 304 => 0x2, 344 => 'SerialNumber' },
	'serialnumberformat' => { 49 => 0x15, 79 => 0x183b },
	'seriesdatetime' => { 335 => 'SeriesDateTime' },
	'seriesdescription' => { 335 => 'SeriesDescription' },
	'seriesmodality' => { 335 => 'SeriesModality' },
	'seriesnumber' => { 335 => 'SeriesNumber' },
	'serviceidentifier' => { 102 => 0x1e },
	'setbuttoncrosskeysfunc' => { 69 => 0x0, 70 => 0x0 },
	'setbuttonwhenshooting' => { 64 => 0x1, 66 => 0x704, 72 => 0xc },
	'setfunctionwhenshooting' => { 67 => 0x0, 68 => 0x1, 71 => 0x1 },
	'shadingcompensation' => { 229 => 0x50c },
	'shadingcompensation2' => { 233 => 0x1012 },
	'shadow' => { 304 => 0xe },
	'shadowcorrection' => { 279 => 0x79 },
	'shadowprotection' => { 211 => 0x0 },
	'shadows' => { 93 => 0xfe52, 341 => 'Shadows', 347 => 'Shadows' },
	'shadows2012' => { 347 => 'Shadows2012' },
	'shadowscale' => { 93 => 0xc633 },
	'shadowtint' => { 347 => 'ShadowTint' },
	'shakereduction' => { 280 => 0x1 },
	'sharpendetail' => { 347 => 'SharpenDetail' },
	'sharpenedgemasking' => { 347 => 'SharpenEdgeMasking' },
	'sharpening' => { 250 => 0x300b },
	'sharpeningadj' => { 215 => 0x2b },
	'sharpenradius' => { 347 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 7 => 0x72, 9 => 0x74, 27 => 0xf, 58 => 0x2, 88 => 0xb, 89 => [0x3011,0x21], 93 => [0xa40a,0xfe56], 98 => 0x1001, 109 => 0x6b, 118 => 0x37, 123 => 'Sharpness', 145 => 0x21, 146 => 0x30, 147 => 0x26, 148 => 0x18, 153 => 0x3, 179 => 0x6, 181 => 0x32, 234 => 0x100f, 248 => 0x41, 279 => 0x21, 284 => 0xb, 292 => 0x26, 295 => 0x22, 296 => 0x1003, 304 => 0x11, 308 => 0x1c, 309 => 0x19, 319 => 0x2006, 347 => 'Sharpness', 351 => 'Sharpness' },
	'sharpnessadj' => { 84 => 0x25a, 333 => 0x801a },
	'sharpnessfactor' => { 234 => 0x102a },
	'sharpnessfaithful' => { 16 => 0xf5, 54 => 0x64, 55 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 58 => 0x3 },
	'sharpnesslandscape' => { 16 => 0xf3, 54 => 0x34, 55 => 0x34 },
	'sharpnessmonochrome' => { 16 => 0xf6, 54 => 0x7c, 55 => 0x7c },
	'sharpnessneutral' => { 16 => 0xf4, 54 => 0x4c, 55 => 0x4c },
	'sharpnessovershoot' => { 333 => 0x801b },
	'sharpnessportrait' => { 16 => 0xf2, 54 => 0x1c, 55 => 0x1c },
	'sharpnesssetting' => { 229 => 0x506, 237 => 0x1013, 310 => 0x12, 322 => 0xa },
	'sharpnessstandard' => { 16 => 0xf1, 54 => 0x4, 55 => 0x4 },
	'sharpnessthreshold' => { 333 => 0x801d },
	'sharpnessundershoot' => { 333 => 0x801c },
	'sharpnessunknown' => { 55 => 0x94 },
	'sharpnessuserdef1' => { 16 => 0xf7, 54 => 0x94, 55 => 0xac },
	'sharpnessuserdef2' => { 16 => 0xf8, 54 => 0xac, 55 => 0xc4 },
	'sharpnessuserdef3' => { 16 => 0xf9, 54 => 0xc4, 55 => 0xdc },
	'shootinginfodisplay' => { 219 => '13.2', 224 => '10.2', 225 => '4.1', 228 => '5.3' },
	'shootinginfomonitorofftime' => { 224 => '9.1', 225 => '21.2', 228 => '22.2' },
	'shootingmode' => { 123 => 'ShootingMode', 179 => 0x89, 248 => 0x1f },
	'shootingmodesetting' => { 220 => '5.1' },
	'shortdescription' => { 349 => 'shortdescription' },
	'shortdocumentid' => { 101 => 0xba },
	'shortownername' => { 16 => 0xac },
	'shortreleasetimelag' => { 66 => 0x80d },
	'shotdate' => { 369 => 'shotDate' },
	'shotday' => { 369 => 'shotDay' },
	'shotlocation' => { 369 => 'shotLocation' },
	'shotname' => { 369 => 'shotName' },
	'shotnumber' => { 369 => 'shotNumber' },
	'shotnumbersincepowerup' => { 321 => 0x44e, 326 => 0x1a, 327 => 0x16 },
	'shotsize' => { 369 => 'shotSize' },
	'shutter-aelock' => { 64 => 0x4, 66 => 0x701, 67 => 0x3, 68 => 0x4, 69 => 0x3, 70 => 0x3, 71 => 0x4, 72 => 0x2 },
	'shutteraelbutton' => { 65 => 0x4 },
	'shutterbuttonafonbutton' => { 66 => 0x701 },
	'shuttercount' => { 8 => 0x176, 44 => 0x1, 179 => 0xa7, 185 => [0x6a,0x157,0x24d], 186 => 0x286, 187 => 0x279, 188 => 0x284, 189 => 0x242, 190 => 0x280, 191 => 0x276, 192 => [0x27d,0x27f], 193 => 0x246, 194 => 0x2d6, 195 => 0x321, 196 => 0xbd8, 197 => 0x287, 198 => 0x320, 199 => 0x24a, 200 => 0x5fb, 201 => 0x2d5, 279 => 0x5d, 318 => 0x846, 320 => [0x125,0x14a] },
	'shuttercurtainsync' => { 64 => 0xf, 65 => 0xf, 66 => 0x305, 67 => 0xe, 68 => 0xf, 69 => 0x8, 70 => 0x8, 71 => 0xf, 72 => 0x8 },
	'shuttermode' => { 109 => 0x1b },
	'shutterreleasebuttonae-l' => { 219 => '17.7', 221 => '16.1', 222 => '17.1', 223 => '17.1', 224 => '7.1', 225 => '17.5', 228 => '18.2' },
	'shutterreleasemethod' => { 79 => 0x1010 },
	'shutterreleasenocfcard' => { 64 => 0x2, 65 => 0x2, 72 => 0xf },
	'shutterreleasetiming' => { 79 => 0x1011 },
	'shutterspeedrange' => { 66 => 0x10c },
	'shutterspeedsetting' => { 148 => 0x6, 308 => 0x2f, 309 => 0x28, 310 => 0x0 },
	'shutterspeedvalue' => { 75 => 0x1, 93 => 0x9201, 234 => 0x1000, 351 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 358 => 'SidecarForExtension' },
	'similarityindex' => { 101 => 0xe4 },
	'singleframebracketing' => { 148 => 0x21 },
	'slaveflashmeteringsegments' => { 279 => 0x20b },
	'slowshutter' => { 60 => 0x8 },
	'slowsync' => { 98 => 0x1030 },
	'smartrange' => { 301 => 0xa012 },
	'smileshutter' => { 310 => 0x31 },
	'smileshuttermode' => { 310 => 0x27 },
	'smoothness' => { 93 => 0xfe57, 347 => 'Smoothness' },
	'softskineffect' => { 319 => 0x200f },
	'software' => { 93 => 0x131, 124 => 'Software', 240 => 'Software', 304 => 0x18, 365 => 'Software' },
	'softwareversion' => { 303 => 0x207 },
	'sonydatetime' => { 324 => 0x6 },
	'sonyimageheight' => { 324 => 0x1a },
	'sonyimagesize' => { 148 => 0x3b, 308 => 0x54, 309 => 0x54, 310 => 0x9 },
	'sonyimagewidth' => { 324 => 0x1c },
	'sonymodelid' => { 319 => 0xb001 },
	'sonyquality' => { 148 => 0x3c },
	'source' => { 101 => 0x73, 240 => 'Source', 348 => 'source', 349 => 'source', 358 => 'Source' },
	'sourcedirectoryindex' => { 266 => 0x0 },
	'sourcefileindex' => { 266 => 0x2 },
	'sourcephotoscount' => { 337 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 351 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 351 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 351 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 351 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 351 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 369 => 'speakerPlacement' },
	'specialeffectlevel' => { 89 => 0x3030 },
	'specialeffectmode' => { 89 => 0x2076 },
	'specialeffectsetting' => { 89 => 0x3031 },
	'specialinstructions' => { 101 => 0x28 },
	'specialmode' => { 234 => 0x200, 303 => 0x200 },
	'spectralsensitivity' => { 93 => 0x8824, 351 => 'SpectralSensitivity' },
	'splittoningbalance' => { 347 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 347 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 347 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 347 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 347 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 145 => 0x2d },
	'spotfocuspointy' => { 145 => 0x2e },
	'spotmeteringmode' => { 27 => 0x27 },
	'spotmeterlinktoafpoint' => { 66 => 0x107 },
	'sractive' => { 260 => '17.1' },
	'srawquality' => { 27 => 0x2e },
	'srfocallength' => { 280 => 0x3 },
	'srhalfpresstime' => { 280 => 0x2 },
	'srresult' => { 280 => 0x0 },
	'standardoutputhighlightpoint' => { 85 => 0x14 },
	'standardoutputsensitivity' => { 93 => 0x8831 },
	'standardoutputshadowpoint' => { 85 => 0x15 },
	'standardrawcolortone' => { 85 => 0xd },
	'standardrawcontrast' => { 85 => 0xf },
	'standardrawhighlight' => { 85 => 0x75 },
	'standardrawhighlightpoint' => { 85 => 0x12 },
	'standardrawlinear' => { 85 => 0x10 },
	'standardrawsaturation' => { 85 => 0xe },
	'standardrawshadow' => { 85 => 0x7e },
	'standardrawshadowpoint' => { 85 => 0x13 },
	'standardrawsharpness' => { 85 => 0x11 },
	'standardunsharpmaskfineness' => { 85 => 0x94 },
	'standardunsharpmaskstrength' => { 85 => 0x92 },
	'standardunsharpmaskthreshold' => { 85 => 0x96 },
	'standbytimer' => { 223 => '18.1' },
	'startingpage' => { 360 => 'startingPage' },
	'startmovieshooting' => { 66 => 0x70d },
	'starttimecode' => { 369 => 'startTimecode' },
	'starttimecodetimeformat' => { 369 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 369 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 369 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 128 => 'State', 248 => 0x6b, 358 => 'State' },
	'status' => { 340 => 'Status' },
	'stitchingsoftware' => { 337 => 'StitchingSoftware' },
	'storagemethod' => { 152 => 0x12 },
	'straightenangle' => { 212 => 0x2fc08431 },
	'stretchmode' => { 369 => 'stretchMode' },
	'studydatetime' => { 335 => 'StudyDateTime' },
	'studydescription' => { 335 => 'StudyDescription' },
	'studyid' => { 335 => 'StudyID' },
	'studyphysician' => { 335 => 'StudyPhysician' },
	'sub-location' => { 101 => 0x5c },
	'subfiledata' => { 131 => 'data' },
	'subfiledirectory' => { 131 => '1Directory' },
	'subfilemimetype' => { 131 => '2MIME' },
	'subfilename' => { 131 => '1Name' },
	'subfileresource' => { 131 => 'rsrc' },
	'subfiletype' => { 93 => 0xfe, 131 => '0Type' },
	'subject' => { 238 => 'Subject', 291 => 'Subject', 348 => 'subject', 357 => 'Subject', 370 => 'subject' },
	'subjectarea' => { 93 => 0x9214, 351 => 'SubjectArea' },
	'subjectcode' => { 355 => 'SubjectCode' },
	'subjectdistance' => { 93 => 0x9206, 109 => 0x3e, 351 => 'SubjectDistance' },
	'subjectdistancerange' => { 93 => 0xa40c, 351 => 'SubjectDistanceRange' },
	'subjectlocation' => { 93 => 0xa214, 351 => 'SubjectLocation' },
	'subjectprogram' => { 145 => 0x22 },
	'subjectreference' => { 101 => 0xc },
	'sublabels4' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 354 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 354 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 93 => 0x9290 },
	'subsectimedigitized' => { 93 => 0x9292 },
	'subsectimeoriginal' => { 93 => 0x9291 },
	'subsection1' => { 360 => 'subsection1' },
	'subsection2' => { 360 => 'subsection2' },
	'subsection3' => { 360 => 'subsection3' },
	'subsection4' => { 360 => 'subsection4' },
	'subversionfilename' => { 354 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 354 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 354 => 'SubVersions' },
	'superimposeddisplay' => { 64 => 0xa, 66 => 0x510, 67 => 0x9, 68 => 0xa, 71 => 0xa, 72 => 0xe },
	'supermacro' => { 49 => 0x1a },
	'supplementalcategories' => { 101 => 0x14, 358 => 'SupplementalCategories' },
	'supplementaltype' => { 103 => 0x37 },
	'svisosetting' => { 260 => 0x14 },
	'sweeppanoramadirection' => { 310 => 0x33 },
	'sweeppanoramasize' => { 310 => 0x32 },
	'switchtoregisteredafpoint' => { 65 => 0x12, 66 => 0x50a },
	'tagged' => { 286 => 0xdd, 287 => 'Tagged', 342 => 'tagged' },
	'tagslist' => { 350 => 'TagsList' },
	'tagstructure' => { 354 => 'TagStructure' },
	'takenumber' => { 369 => 'takeNumber' },
	'tapename' => { 369 => 'tapeName' },
	'targetaperture' => { 60 => 0x4 },
	'targetcompressionratio' => { 77 => 0x1 },
	'targetdistancesetting' => { 79 => 0x1807 },
	'targetexposuretime' => { 60 => 0x5 },
	'targetimagetype' => { 79 => 0x100a },
	'taxon' => { 92 => 'Taxon' },
	'taxonacceptednameusage' => { 92 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 92 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 92 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 92 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 92 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 92 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 92 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 92 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 92 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 92 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 92 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 92 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 92 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 92 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnomenclaturalcode' => { 92 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 92 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 92 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 92 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonparentnameusage' => { 92 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 92 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 92 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 92 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 92 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 92 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 92 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 92 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 92 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 92 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 92 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 92 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 92 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 360 => 'teaser' },
	'teleconverter' => { 150 => 0x105, 319 => 0x105 },
	'tempo' => { 369 => 'tempo' },
	'termsandconditionstext' => { 359 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 359 => 'TermsAndConditionsURL' },
	'textencoding' => { 178 => 0x4 },
	'textlayername' => { 358 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 358 => 'TextLayers' },
	'textlayertext' => { 358 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 248 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 93 => 0x107 },
	'thumbnailfilename' => { 79 => 0x817 },
	'thumbnailformat' => { 367 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 111 => 0xfa55, 367 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 79 => 0x2008, 90 => 'ThumbnailImage', 96 => 0x3, 134 => 'data', 234 => 0x100, 367 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 134 => '1Name' },
	'thumbnailimagesize' => { 134 => 'ImageSize' },
	'thumbnailimagetype' => { 134 => '0Type' },
	'thumbnailimagevalidarea' => { 49 => 0x13 },
	'thumbnaillength' => { 93 => 0x202 },
	'thumbnailoffset' => { 93 => 0x201 },
	'thumbnails' => { 367 => 'Thumbnails' },
	'thumbnailwidth' => { 111 => 0xfa54, 367 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 360 => 'ticker' },
	'tilelength' => { 93 => 0x143 },
	'tilewidth' => { 93 => 0x142 },
	'time' => { 107 => 0x401, 279 => 0x7 },
	'timecodes' => { 93 => 0xc763 },
	'timecreated' => { 101 => 0x3c, 109 => 0x14, 118 => 0x10, 287 => 'TimeCreated' },
	'timeperiod' => { 360 => 'timePeriod' },
	'timerfunctionbutton' => { 220 => '5.2', 221 => '12.1', 222 => '13.1' },
	'timerlength' => { 66 => 0x80c },
	'timescaleparams' => { 369 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 369 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 369 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 369 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 102 => 0x50 },
	'timesignature' => { 369 => 'timeSignature' },
	'timesincepoweron' => { 248 => 0x29 },
	'timestamp' => { 8 => 0x45e, 16 => 0x11c, 240 => 'TimeStamp', 343 => 'Timestamp' },
	'timestamp1' => { 8 => 0x45a },
	'timezone' => { 61 => 0x1, 204 => 0x0 },
	'timezonecity' => { 61 => 0x2 },
	'timezonecode' => { 82 => 0x1 },
	'timezoneinfo' => { 82 => 0x2 },
	'timezoneoffset' => { 93 => 0x882a },
	'tint' => { 347 => 'Tint' },
	'title' => { 124 => 'Title', 238 => 'Title', 240 => 'Title', 248 => 0x65, 291 => 'Title', 348 => 'title', 357 => 'Title', 367 => 'Title' },
	'tonecomp' => { 179 => 0x81 },
	'tonecurve' => { 58 => 0x1, 279 => 0x402, 347 => 'ToneCurve' },
	'tonecurve1' => { 301 => 0xa040 },
	'tonecurve2' => { 301 => 0xa041 },
	'tonecurve3' => { 301 => 0xa042 },
	'tonecurve4' => { 301 => 0xa043 },
	'tonecurveactive' => { 84 => 0x110 },
	'tonecurveblue' => { 347 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 333 => 0x9003 },
	'tonecurvebluey' => { 333 => 0x9007 },
	'tonecurvebrightnessx' => { 333 => 0x9000 },
	'tonecurvebrightnessy' => { 333 => 0x9004 },
	'tonecurvefilename' => { 107 => 0x1391 },
	'tonecurvegreen' => { 347 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 333 => 0x9002 },
	'tonecurvegreeny' => { 333 => 0x9006 },
	'tonecurveinterpolation' => { 84 => 0x159 },
	'tonecurvemode' => { 84 => 0x113 },
	'tonecurvename' => { 347 => 'ToneCurveName' },
	'tonecurvename2012' => { 347 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 84 => 0x3c },
	'tonecurvepv2012' => { 347 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 347 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 347 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 347 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 347 => 'ToneCurveRed' },
	'tonecurveredx' => { 333 => 0x9001 },
	'tonecurveredy' => { 333 => 0x9005 },
	'tonecurves' => { 279 => 0x403 },
	'toningeffect' => { 44 => 0xf, 179 => 0xb3, 181 => 0x38 },
	'toningeffectfaithful' => { 54 => 0x74, 55 => 0x74 },
	'toningeffectlandscape' => { 54 => 0x44, 55 => 0x44 },
	'toningeffectmonochrome' => { 16 => 0x108, 54 => 0x8c, 55 => 0x8c },
	'toningeffectneutral' => { 54 => 0x5c, 55 => 0x5c },
	'toningeffectportrait' => { 54 => 0x2c, 55 => 0x2c },
	'toningeffectstandard' => { 54 => 0x14, 55 => 0x14 },
	'toningeffectunknown' => { 55 => 0xa4 },
	'toningeffectuserdef1' => { 54 => 0xa4, 55 => 0xbc },
	'toningeffectuserdef2' => { 54 => 0xbc, 55 => 0xd4 },
	'toningeffectuserdef3' => { 54 => 0xd4, 55 => 0xec },
	'toningsaturation' => { 181 => 0x39 },
	'totalzoom' => { 109 => 0x62 },
	'tracknumber' => { 369 => 'trackNumber' },
	'tracks' => { 369 => 'Tracks' },
	'tracksframerate' => { 369 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 369 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 369 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 369 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 369 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 369 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 369 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 369 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 369 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 369 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 369 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 369 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 369 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 369 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 369 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 369 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 369 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 131 => 'zmie' },
	'transferfunction' => { 93 => 0x12d, 365 => 'TransferFunction' },
	'transform' => { 248 => [0x8012,0x59] },
	'transmissionreference' => { 358 => 'TransmissionReference' },
	'trapped' => { 238 => 'Trapped', 357 => 'Trapped' },
	'travelday' => { 248 => 0x36 },
	'triggermode' => { 292 => 0x6 },
	'tstop' => { 93 => 0xc772 },
	'ttl_da_adown' => { 267 => 0x5 },
	'ttl_da_aup' => { 267 => 0x4 },
	'ttl_da_bdown' => { 267 => 0x7 },
	'ttl_da_bup' => { 267 => 0x6 },
	'tungstenawb' => { 257 => 0x1 },
	'tvexposuretimesetting' => { 260 => 0x12 },
	'type' => { 348 => 'type', 364 => 'type' },
	'typestatus' => { 92 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 93 => 0xc614 },
	'uniquedocumentid' => { 101 => 0xbb },
	'uniqueobjectname' => { 102 => 0x64 },
	'unknownblock' => { 279 => 0x405 },
	'unknownblock1' => { 233 => 0x635 },
	'unknownblock2' => { 233 => 0x636 },
	'unknownblock3' => { 233 => 0x1103 },
	'unknownblock4' => { 233 => 0x1104 },
	'unknowncontrast' => { 85 => 0x45 },
	'unknownev' => { 107 => 0x1 },
	'unknownlinear' => { 85 => 0x46 },
	'unknownnumber' => { 79 => 0x180b },
	'unknownoutputhighlightpoint' => { 85 => 0x4a },
	'unknownoutputshadowpoint' => { 85 => 0x4b },
	'unknownrawhighlight' => { 85 => 0x7b },
	'unknownrawhighlightpoint' => { 85 => 0x48 },
	'unknownrawshadow' => { 85 => 0x84 },
	'unknownrawshadowpoint' => { 85 => 0x49 },
	'unknownsharpness' => { 85 => 0x47 },
	'unknowntemperature' => { 95 => 0x4 },
	'unsharp1color' => { 217 => 0x13 },
	'unsharp1halowidth' => { 217 => 0x19 },
	'unsharp1intensity' => { 217 => 0x17 },
	'unsharp1threshold' => { 217 => 0x1b },
	'unsharp2color' => { 217 => 0x2e },
	'unsharp2halowidth' => { 217 => 0x34 },
	'unsharp2intensity' => { 217 => 0x32 },
	'unsharp2threshold' => { 217 => 0x36 },
	'unsharp3color' => { 217 => 0x49 },
	'unsharp3halowidth' => { 217 => 0x4f },
	'unsharp3intensity' => { 217 => 0x4d },
	'unsharp3threshold' => { 217 => 0x51 },
	'unsharp4color' => { 217 => 0x64 },
	'unsharp4halowidth' => { 217 => 0x6a },
	'unsharp4intensity' => { 217 => 0x68 },
	'unsharp4threshold' => { 217 => 0x6c },
	'unsharpcount' => { 217 => 0x0 },
	'unsharpmask' => { 85 => 0x90, 212 => 0x76a43200 },
	'urgency' => { 101 => 0xa, 358 => 'Urgency' },
	'url' => { 124 => 'URL', 240 => 'URL', 289 => 0x40b, 360 => 'url' },
	'usablemeteringmodes' => { 66 => 0x10a },
	'usableshootingmodes' => { 66 => 0x109 },
	'usage' => { 361 => 'usage' },
	'usagefee' => { 362 => 'usageFee' },
	'usageterms' => { 373 => 'UsageTerms' },
	'useguidelines' => { 345 => 'useGuidelines' },
	'usepanoramaviewer' => { 337 => 'UsePanoramaViewer' },
	'usercomment' => { 79 => 0x805, 93 => 0x9286, 351 => 'UserComment' },
	'userdef1picturestyle' => { 16 => 0x10c, 54 => 0xd8, 55 => 0xf0 },
	'userdef2picturestyle' => { 16 => 0x10e, 54 => 0xda, 55 => 0xf2 },
	'userdef3picturestyle' => { 16 => 0x110, 54 => 0xdc, 55 => 0xf4 },
	'userfields' => { 340 => 'UserFields' },
	'userlabel' => { 292 => 0x2b },
	'userprofile' => { 244 => 0x302, 250 => 0x3038 },
	'usmlenselectronicmf' => { 65 => 0x7, 66 => 0x501 },
	'utmeasting' => { 135 => 'Easting' },
	'utmmapdatum' => { 135 => 'Datum' },
	'utmnorthing' => { 135 => 'Northing' },
	'utmzone' => { 135 => 'Zone' },
	'uv-irfiltercorrection' => { 244 => 0x325 },
	'validbits' => { 233 => 0x611, 234 => 0x102c },
	'validpixeldepth' => { 237 => 0x611 },
	'variousmodes' => { 109 => 0x26 },
	'variousmodes2' => { 109 => 0x3a },
	'variprogram' => { 179 => 0xab },
	'version' => { 98 => 0x0, 291 => 'Version', 347 => 'Version' },
	'versioncreatedate' => { 333 => 0xd100 },
	'versionid' => { 370 => 'VersionID' },
	'versionidentifier' => { 360 => 'versionIdentifier' },
	'versionmodifydate' => { 333 => 0xd101 },
	'versions' => { 370 => 'Versions' },
	'versionscomments' => { 370 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 370 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 370 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 370 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 370 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 370 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 370 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 370 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 370 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 370 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 370 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 219 => '3.2' },
	'vfdisplayillumination' => { 66 => 0x510 },
	'vibrance' => { 341 => 'Vibrance', 347 => 'Vibrance' },
	'vibrationreduction' => { 185 => [0x75,0x82,0x1ae], 193 => '586.1', 199 => '590.2', 203 => 0x4 },
	'videoalphamode' => { 369 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 369 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 369 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 369 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 52 => 0x74 },
	'videocolorspace' => { 369 => 'videoColorSpace' },
	'videocompressor' => { 369 => 'videoCompressor' },
	'videofieldorder' => { 369 => 'videoFieldOrder' },
	'videoframerate' => { 369 => 'videoFrameRate' },
	'videoframesize' => { 369 => 'videoFrameSize' },
	'videoframesizeh' => { 369 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 369 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 369 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 369 => 'videoModDate' },
	'videopixelaspectratio' => { 369 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 369 => 'videoPixelDepth' },
	'videoquality' => { 89 => 0x4003 },
	'viewfinderdisplay' => { 219 => '12.4' },
	'viewfinderwarning' => { 219 => '13.4', 225 => '3.5', 226 => '6.2', 228 => '4.4' },
	'viewfinderwarnings' => { 66 => 0x40a },
	'viewinfoduringexposure' => { 66 => 0x407 },
	'viewingmode' => { 310 => 0x2f, 322 => 0x18 },
	'viewingmode2' => { 310 => 0x85 },
	'vignetteamount' => { 347 => 'VignetteAmount' },
	'vignettecontrol' => { 179 => 0x2a, 212 => 0x76a43205 },
	'vignettecontrolintensity' => { 212 => 0xac6bd5c0 },
	'vignettemidpoint' => { 347 => 'VignetteMidpoint' },
	'vignettingcorrection' => { 319 => 0x2011 },
	'voicememo' => { 303 => 0x216 },
	'volume' => { 360 => 'volume' },
	'vr_0x66' => { 185 => 0x66 },
	'vrdoffset' => { 49 => 0xd0 },
	'vrmode' => { 203 => 0x6 },
	'wb_bluelevel3500k' => { 151 => 0x19a },
	'wb_bluelevel6500k' => { 151 => 0x18a },
	'wb_bluelevelcustom' => { 151 => 0x18e },
	'wb_bluelevelscloudy' => { 151 => 0x106 },
	'wb_bluelevelsdaylight' => { 151 => 0xea },
	'wb_bluelevelsflash' => { 151 => 0x122 },
	'wb_bluelevelsfluorescent' => { 151 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 151 => 0x254 },
	'wb_bluelevelsshade' => { 151 => 0x176 },
	'wb_bluelevelstungsten' => { 151 => 0xce },
	'wb_gbrglevels' => { 151 => 0xae, 154 => 0x4 },
	'wb_glevel' => { 233 => 0x11f },
	'wb_glevel3000k' => { 233 => 0x113 },
	'wb_glevel3300k' => { 233 => 0x114 },
	'wb_glevel3600k' => { 233 => 0x115 },
	'wb_glevel3900k' => { 233 => 0x116 },
	'wb_glevel4000k' => { 233 => 0x117 },
	'wb_glevel4300k' => { 233 => 0x118 },
	'wb_glevel4500k' => { 233 => 0x119 },
	'wb_glevel4800k' => { 233 => 0x11a },
	'wb_glevel5300k' => { 233 => 0x11b },
	'wb_glevel6000k' => { 233 => 0x11c },
	'wb_glevel6600k' => { 233 => 0x11d },
	'wb_glevel7500k' => { 233 => 0x11e },
	'wb_grbglevels' => { 162 => 0x0 },
	'wb_rbgglevels' => { 159 => 0x0 },
	'wb_rblevels' => { 179 => 0xc, 233 => 0x100 },
	'wb_rblevels3000k' => { 233 => 0x102 },
	'wb_rblevels3300k' => { 233 => 0x103 },
	'wb_rblevels3500k' => { 151 => 0x430 },
	'wb_rblevels3600k' => { 233 => 0x104 },
	'wb_rblevels3900k' => { 233 => 0x105 },
	'wb_rblevels4000k' => { 233 => 0x106 },
	'wb_rblevels4300k' => { 233 => 0x107 },
	'wb_rblevels4500k' => { 233 => 0x108 },
	'wb_rblevels4800k' => { 233 => 0x109 },
	'wb_rblevels5300k' => { 233 => 0x10a },
	'wb_rblevels6000k' => { 233 => 0x10b },
	'wb_rblevels6500k' => { 151 => 0x420 },
	'wb_rblevels6600k' => { 233 => 0x10c },
	'wb_rblevels7500k' => { 233 => 0x10d },
	'wb_rblevelsauto' => { 237 => 0x110 },
	'wb_rblevelscloudy' => { 151 => 0x3f0, 153 => 0x10, 237 => 0x121 },
	'wb_rblevelscoolwhitef' => { 151 => 0x308, 153 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 237 => 0x132 },
	'wb_rblevelscustom' => { 151 => 0x424 },
	'wb_rblevelscwb1' => { 233 => 0x10e },
	'wb_rblevelscwb2' => { 233 => 0x10f },
	'wb_rblevelscwb3' => { 233 => 0x110 },
	'wb_rblevelscwb4' => { 233 => 0x111 },
	'wb_rblevelsdaylight' => { 151 => [0x3ec,0x528], 153 => 0xc },
	'wb_rblevelsdaylightf' => { 153 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 237 => 0x130 },
	'wb_rblevelsdaywhitef' => { 153 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 237 => 0x131 },
	'wb_rblevelseveningsunlight' => { 237 => 0x124 },
	'wb_rblevelsfineweather' => { 237 => 0x122 },
	'wb_rblevelsflash' => { 151 => [0x3f4,0x304], 153 => 0x18 },
	'wb_rblevelsshade' => { 151 => 0x418, 153 => 0x20, 237 => 0x120 },
	'wb_rblevelstungsten' => { 151 => 0x3e8, 153 => 0x8, 237 => 0x123 },
	'wb_rblevelsunknown' => { 153 => 0x1c },
	'wb_rblevelsused' => { 237 => 0x100 },
	'wb_rblevelswhitef' => { 153 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 237 => 0x133 },
	'wb_redlevel3500k' => { 151 => 0x198 },
	'wb_redlevel6500k' => { 151 => 0x188 },
	'wb_redlevelcustom' => { 151 => 0x18c },
	'wb_redlevelscloudy' => { 151 => 0xf8 },
	'wb_redlevelsdaylight' => { 151 => 0xdc },
	'wb_redlevelsflash' => { 151 => 0x114 },
	'wb_redlevelsfluorescent' => { 151 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 151 => 0x1be },
	'wb_redlevelsshade' => { 151 => 0x168 },
	'wb_redlevelstungsten' => { 151 => 0xc0 },
	'wb_rgbglevels' => { 161 => 0x0 },
	'wb_rgblevels' => { 151 => [0x546,0x96], 245 => 0xd, 246 => 0x413, 250 => 0x3036 },
	'wb_rggblevels' => { 154 => 0x4, 160 => 0x0 },
	'wb_rggblevelsasshot' => { 30 => 0x0, 31 => 0x19, 32 => 0x22, 33 => 0x3f, 36 => 0x3f, 37 => 0x3f },
	'wb_rggblevelsauto' => { 28 => 0x0, 30 => 0x5, 31 => 0x1e, 32 => 0x18, 33 => 0x44, 36 => 0x44, 37 => 0x44, 301 => 0xa022 },
	'wb_rggblevelsblack' => { 301 => 0xa028 },
	'wb_rggblevelscloudy' => { 28 => 0xc, 30 => 0x1e, 31 => 0x2d, 32 => 0x31, 33 => 0x58, 36 => 0x71, 37 => 0x8a, 279 => 0x20f, 285 => 0x14 },
	'wb_rggblevelscustom' => { 28 => 0x1c, 33 => 0x80 },
	'wb_rggblevelscustom1' => { 31 => 0x41 },
	'wb_rggblevelscustom2' => { 31 => 0x46 },
	'wb_rggblevelsdaylight' => { 28 => 0x4, 30 => 0x14, 31 => 0x23, 32 => 0x27, 33 => 0x4e, 36 => 0x67, 37 => 0x80, 279 => 0x20d, 285 => 0x2 },
	'wb_rggblevelsflash' => { 28 => 0x18, 30 => 0x32, 31 => 0x3c, 32 => 0x45, 33 => 0x6c, 36 => 0x85, 37 => 0x9e, 279 => 0x214, 285 => 0x41 },
	'wb_rggblevelsfluorescent' => { 28 => 0x14, 30 => 0x28, 31 => 0x37, 32 => 0x3b, 33 => 0x62, 36 => 0x7b, 37 => 0x94 },
	'wb_rggblevelsfluorescentd' => { 279 => 0x211, 285 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 285 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 279 => 0x212, 285 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 279 => 0x213, 285 => 0x38 },
	'wb_rggblevelsilluminator1' => { 301 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 301 => 0xa024 },
	'wb_rggblevelskelvin' => { 28 => 0x20, 30 => 0x2d, 32 => 0x40, 33 => 0x67, 36 => 0x80, 37 => 0x99 },
	'wb_rggblevelsmeasured' => { 30 => 0xa, 33 => 0x49, 36 => 0x49, 37 => 0x49 },
	'wb_rggblevelspc1' => { 32 => 0x90, 33 => 0x71 },
	'wb_rggblevelspc2' => { 32 => 0x95, 33 => 0x76 },
	'wb_rggblevelspc3' => { 32 => 0x9a, 33 => 0x7b },
	'wb_rggblevelsshade' => { 28 => 0x8, 30 => 0x19, 31 => 0x28, 32 => 0x2c, 33 => 0x53, 36 => 0x6c, 37 => 0x85, 279 => 0x20e, 285 => 0xb },
	'wb_rggblevelstungsten' => { 28 => 0x10, 30 => 0x23, 31 => 0x32, 32 => 0x36, 33 => 0x5d, 36 => 0x76, 37 => 0x8f, 279 => 0x210, 285 => 0x1d },
	'wb_rggblevelsuncorrected' => { 301 => 0xa021 },
	'wb_rggblevelsunknown' => { 30 => 0xf, 32 => 0x1d, 36 => 0x4e, 37 => 0x4e, 285 => 0x53 },
	'wb_rggblevelsunknown10' => { 30 => 0x5f, 32 => 0x72, 36 => 0x9e, 37 => 0x7b },
	'wb_rggblevelsunknown11' => { 30 => 0x64, 32 => 0x77, 36 => 0xa3, 37 => 0xa3 },
	'wb_rggblevelsunknown12' => { 30 => 0x69, 32 => 0x7c, 36 => 0xa8, 37 => 0xa8 },
	'wb_rggblevelsunknown13' => { 30 => 0x6e, 32 => 0x81, 36 => 0xad, 37 => 0xad },
	'wb_rggblevelsunknown14' => { 32 => 0x86, 36 => 0xb2, 37 => 0xb2 },
	'wb_rggblevelsunknown15' => { 32 => 0x8b, 36 => 0xb7, 37 => 0xb7 },
	'wb_rggblevelsunknown16' => { 32 => 0x9f, 37 => 0xbc },
	'wb_rggblevelsunknown17' => { 37 => 0xc1 },
	'wb_rggblevelsunknown18' => { 37 => 0xc6 },
	'wb_rggblevelsunknown19' => { 37 => 0xcb },
	'wb_rggblevelsunknown2' => { 30 => 0x37, 32 => 0x4a, 36 => 0x53, 37 => 0x53 },
	'wb_rggblevelsunknown20' => { 37 => 0xd0 },
	'wb_rggblevelsunknown3' => { 30 => 0x3c, 32 => 0x4f, 36 => 0x58, 37 => 0x58 },
	'wb_rggblevelsunknown4' => { 30 => 0x41, 32 => 0x54, 36 => 0x5d, 37 => 0x5d },
	'wb_rggblevelsunknown5' => { 30 => 0x46, 32 => 0x59, 36 => 0x62, 37 => 0x62 },
	'wb_rggblevelsunknown6' => { 30 => 0x4b, 32 => 0x5e, 36 => 0x8a, 37 => 0x67 },
	'wb_rggblevelsunknown7' => { 30 => 0x50, 32 => 0x63, 36 => 0x8f, 37 => 0x6c },
	'wb_rggblevelsunknown8' => { 30 => 0x55, 32 => 0x68, 36 => 0x94, 37 => 0x71 },
	'wb_rggblevelsunknown9' => { 30 => 0x5a, 32 => 0x6d, 36 => 0x99, 37 => 0x76 },
	'wb_rggblevelsuserselected' => { 285 => 0x5c },
	'wbadjbluebalance' => { 218 => 0x8 },
	'wbadjcolortemp' => { 84 => 0x1a },
	'wbadjlighting' => { 218 => 0x15 },
	'wbadjlightingsubtype' => { 218 => 0x14 },
	'wbadjmode' => { 218 => 0x10 },
	'wbadjredbalance' => { 218 => 0x0 },
	'wbadjrggblevels' => { 84 => 0x6 },
	'wbadjtemperature' => { 218 => 0x18 },
	'wbadjtint' => { 218 => 0x25 },
	'wbbluelevel' => { 244 => 0x324, 248 => 0x8006, 252 => 0x26 },
	'wbbracketmode' => { 44 => 0x9 },
	'wbbracketshotnumber' => { 151 => 0x2b },
	'wbbracketvalueab' => { 44 => 0xc },
	'wbbracketvaluegm' => { 44 => 0xd },
	'wbfinetuneactive' => { 84 => 0x24 },
	'wbfinetunesaturation' => { 84 => 0x28 },
	'wbfinetunetone' => { 84 => 0x2c },
	'wbgreenlevel' => { 244 => 0x323, 248 => 0x8005, 252 => 0x25 },
	'wbmediaimagesizesetting' => { 66 => 0x708 },
	'wbmode' => { 153 => 0x4, 234 => 0x1015 },
	'wbredlevel' => { 244 => 0x322, 248 => 0x8004, 252 => 0x24 },
	'wbscale' => { 154 => 0x0 },
	'wbshiftab' => { 58 => 0xc, 248 => 0x46, 261 => 0x10 },
	'wbshiftab_gm' => { 319 => 0x2014 },
	'wbshiftgm' => { 58 => 0xd, 248 => 0x47, 261 => 0x11 },
	'webstatement' => { 373 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0xbc, 7 => 0x36, 8 => 0x5e, 9 => 0x36, 10 => 0x78, 11 => 0x6f, 12 => 0x6f, 13 => 0x73, 14 => 0x6f, 15 => 0x78, 16 => 0x54, 17 => 0x6f, 18 => 0xbc, 19 => 0x7b, 21 => 0xbc, 22 => 0xc2, 23 => 0x77, 58 => 0x8, 60 => 0x7, 88 => 0x7, 89 => [0x19,0x2012], 93 => [0xa403,0xfe4e], 98 => 0x1002, 107 => 0x3fc, 108 => 0xfa0d, 109 => 0x40, 145 => 0x3, 146 => 0xe, 147 => 0x4, 148 => 0xb, 150 => 0x115, 179 => 0x5, 202 => 0x7, 244 => 0x304, 248 => 0x3, 250 => 0x3033, 279 => 0x19, 284 => 0x7, 295 => 0x26, 304 => [0x3c,0x7,0x58], 319 => [0x115,0xb054], 347 => 'WhiteBalance', 351 => 'WhiteBalance' },
	'whitebalance2' => { 229 => 0x500 },
	'whitebalanceadj' => { 84 => 0x18, 212 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 257 => 0x0 },
	'whitebalancebias' => { 89 => 0x2011, 234 => 0x304, 248 => 0x23 },
	'whitebalanceblue' => { 58 => 0x7 },
	'whitebalancebracket' => { 229 => 0x502, 234 => 0x303 },
	'whitebalancebracketing' => { 148 => 0x22, 151 => 0x2c, 318 => 0x2c },
	'whitebalancecomp' => { 237 => 0x1001 },
	'whitebalancefinetune' => { 98 => 0x100a, 148 => 0x38, 150 => 0x112, 179 => 0xb, 308 => 0x6, 319 => 0x112 },
	'whitebalancemode' => { 279 => 0x1a },
	'whitebalancered' => { 58 => 0x6 },
	'whitebalanceset' => { 260 => 0xa },
	'whitebalancesetting' => { 148 => 0x23, 310 => 0x16, 322 => 0xd },
	'whitebalancetemperature' => { 229 => 0x501 },
	'whiteboard' => { 234 => 0x301 },
	'whitelevel' => { 93 => 0xc61d },
	'whitepoint' => { 93 => 0x13e, 279 => 0x201, 365 => 'WhitePoint' },
	'whites2012' => { 347 => 'Whites2012' },
	'widefocuszone' => { 145 => 0x2f },
	'widerange' => { 303 => 0x20f },
	'wordcount' => { 360 => 'wordCount' },
	'workcolorspace' => { 84 => 0x270 },
	'worktodo' => { 352 => 'WorkToDo' },
	'worldtimelocation' => { 248 => 0x3a, 279 => 0x22, 283 => '0.1' },
	'writer-editor' => { 101 => 0x7a },
	'x3filllight' => { 304 => 0x12 },
	'xml' => { 105 => 'xml ' },
	'xmp' => { 83 => 0xffff00f6, 94 => 'XMP' },
	'xmptoolkit' => { 366 => 'xmptk' },
	'xpauthor' => { 93 => 0x9c9d },
	'xpcomment' => { 93 => 0x9c9c },
	'xpkeywords' => { 93 => 0x9c9e },
	'xposition' => { 93 => 0x11e },
	'xpsubject' => { 93 => 0x9c9f },
	'xptitle' => { 93 => 0x9c9b },
	'xresolution' => { 93 => 0x11a, 104 => 0x3, 290 => 0x0, 365 => 'XResolution' },
	'xyresolution' => { 97 => 0x3 },
	'ycbcrcoefficients' => { 93 => 0x211, 365 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 93 => 0x213, 365 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 93 => 0x212, 365 => 'YCbCrSubSampling' },
	'yearcreated' => { 109 => 0x10, 118 => 0xc },
	'yposition' => { 93 => 0x11f },
	'yresolution' => { 93 => 0x11b, 104 => 0x5, 290 => 0x4, 365 => 'YResolution' },
	'zonematching' => { 150 => 0x10a, 153 => [0x3a,0x4a], 319 => 0xb024 },
	'zonematchingmode' => { 148 => 0x14 },
	'zonematchingon' => { 147 => 0x75 },
	'zonematchingvalue' => { 308 => 0x1f },
	'zoomedpreviewlength' => { 234 => 0xf05 },
	'zoomedpreviewsize' => { 234 => 0xf06 },
	'zoomedpreviewstart' => { 234 => 0xf04 },
	'zoomsourcewidth' => { 27 => 0x24 },
	'zoomstepcount' => { 232 => 0x300, 234 => 0x100d },
	'zoomtargetwidth' => { 27 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeunknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationiterations' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfoa100' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperturedimensions' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedaudiofile' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'framewidth' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'givenname' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'paraminfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'participants' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencetemperature' => 1,
	'referencevirtual' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensorcalibration' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9405' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfok5' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimage' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_cndb' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userlastplayedtime' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8version' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grblevels' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2013, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
